/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.google.common.util.concurrent;

import java.util.concurrent.Executor;
import net.square.sierra.google.common.annotations.GwtCompatible;
import net.square.sierra.google.common.base.Preconditions;
import net.square.sierra.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import net.square.sierra.google.common.util.concurrent.ForwardingFuture;
import net.square.sierra.google.common.util.concurrent.ListenableFuture;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingListenableFuture<V>
extends ForwardingFuture<V>
implements ListenableFuture<V> {
    protected ForwardingListenableFuture() {
    }

    @Override
    protected abstract ListenableFuture<? extends V> delegate();

    @Override
    public void addListener(Runnable listener, Executor exec) {
        this.delegate().addListener(listener, exec);
    }

    public static abstract class SimpleForwardingListenableFuture<V>
    extends ForwardingListenableFuture<V> {
        private final ListenableFuture<V> delegate;

        protected SimpleForwardingListenableFuture(ListenableFuture<V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final ListenableFuture<V> delegate() {
            return this.delegate;
        }
    }
}

