/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.google.common.util.concurrent;

import net.square.sierra.google.common.annotations.GwtCompatible;
import net.square.sierra.google.common.base.Preconditions;
import net.square.sierra.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import net.square.sierra.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

