/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api;

import java.util.logging.Logger;
import net.square.sierra.packetevents.api.event.EventManager;
import net.square.sierra.packetevents.api.injector.ChannelInjector;
import net.square.sierra.packetevents.api.manager.player.PlayerManager;
import net.square.sierra.packetevents.api.manager.protocol.ProtocolManager;
import net.square.sierra.packetevents.api.manager.server.ServerManager;
import net.square.sierra.packetevents.api.netty.NettyManager;
import net.square.sierra.packetevents.api.settings.PacketEventsSettings;
import net.square.sierra.packetevents.api.util.LogManager;
import net.square.sierra.packetevents.api.util.PEVersion;
import net.square.sierra.packetevents.api.util.PEVersions;
import net.square.sierra.packetevents.api.util.updatechecker.UpdateChecker;

public abstract class PacketEventsAPI<T> {
    private final EventManager eventManager = new EventManager();
    private final PacketEventsSettings settings = new PacketEventsSettings();
    private final UpdateChecker updateChecker = new UpdateChecker();
    private final LogManager logManager = new LogManager();
    private static final Logger LOGGER = Logger.getLogger(PacketEventsAPI.class.getName());

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public PacketEventsSettings getSettings() {
        return this.settings;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PEVersion getVersion() {
        return PEVersions.CURRENT;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public abstract void load();

    public abstract boolean isLoaded();

    public abstract void init();

    public abstract boolean isInitialized();

    public abstract void terminate();

    public abstract boolean isTerminated();

    public abstract T getPlugin();

    public abstract ServerManager getServerManager();

    public abstract ProtocolManager getProtocolManager();

    public abstract PlayerManager getPlayerManager();

    public abstract NettyManager getNettyManager();

    public abstract ChannelInjector getInjector();
}

