/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.adventure.serializer.gson;

import java.util.Collections;
import java.util.UUID;
import net.square.sierra.kyori.adventure.key.Key;
import net.square.sierra.kyori.adventure.key.Keyed;
import net.square.sierra.kyori.adventure.nbt.api.BinaryTagHolder;
import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.kyori.adventure.text.event.HoverEvent;
import net.square.sierra.kyori.adventure.util.Codec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class BackwardCompatUtil {
    public static final boolean IS_4_10_0_OR_NEWER;
    public static final boolean IS_4_13_0_OR_NEWER;
    public static final boolean IS_4_15_0_OR_NEWER;
    public static final boolean IS_4_17_0_OR_NEWER;

    private BackwardCompatUtil() {
    }

    public static HoverEvent.ShowItem createShowItem(@NotNull Key item, @Range(from=0L, to=0x7FFFFFFFL) int count, @Nullable BinaryTagHolder nbt) {
        try {
            return HoverEvent.ShowItem.showItem(item, count, nbt);
        }
        catch (NoSuchMethodError ignored) {
            return HoverEvent.ShowItem.of(item, count, nbt);
        }
    }

    public static HoverEvent.ShowEntity createShowEntity(@NotNull Key type, @NotNull UUID id, @Nullable Component name) {
        try {
            return HoverEvent.ShowEntity.showEntity(type, id, name);
        }
        catch (NoSuchMethodError ignored) {
            return HoverEvent.ShowEntity.of(type, id, name);
        }
    }

    @NotNull
    public static <D, E, DX extends Throwable, EX extends Throwable> Codec<D, E, DX, EX> createCodec(@NotNull Codec.Decoder<D, E, DX> decoder, @NotNull Codec.Encoder<D, E, EX> encoder) {
        try {
            return Codec.codec(decoder, encoder);
        }
        catch (NoSuchMethodError ignored) {
            return Codec.of(decoder, encoder);
        }
    }

    static {
        boolean is4_10_0OrNewer = false;
        try {
            BinaryTagHolder.binaryTagHolder("");
            is4_10_0OrNewer = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_4_10_0_OR_NEWER = is4_10_0OrNewer;
        boolean is4_13_0OrNewer = false;
        try {
            Component.translatable().fallback("");
            is4_13_0OrNewer = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_4_13_0_OR_NEWER = is4_13_0OrNewer;
        boolean is4_15_0OrNewer = false;
        try {
            Component.translatable().arguments(Component.empty());
            is4_15_0OrNewer = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_4_15_0_OR_NEWER = is4_15_0OrNewer;
        boolean is4_17_0OrNewer = false;
        try {
            HoverEvent.ShowItem.showItem((Keyed)Key.key("air"), 1, Collections.emptyMap());
            is4_17_0OrNewer = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_4_17_0_OR_NEWER = is4_17_0OrNewer;
    }

    public static interface ShowAchievementToComponent {
        @NotNull
        public Component convert(@NotNull String var1);
    }
}

