/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.adventure.serializer.gson;

import java.util.UUID;
import net.square.sierra.google.gson.Gson;
import net.square.sierra.google.gson.TypeAdapter;
import net.square.sierra.google.gson.TypeAdapterFactory;
import net.square.sierra.google.gson.reflect.TypeToken;
import net.square.sierra.kyori.adventure.key.Key;
import net.square.sierra.kyori.adventure.text.BlockNBTComponent;
import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.kyori.adventure.text.TranslationArgument;
import net.square.sierra.kyori.adventure.text.event.ClickEvent;
import net.square.sierra.kyori.adventure.text.event.HoverEvent;
import net.square.sierra.kyori.adventure.text.format.Style;
import net.square.sierra.kyori.adventure.text.format.TextColor;
import net.square.sierra.kyori.adventure.text.format.TextDecoration;
import net.square.sierra.packetevents.api.adventure.option.OptionState;
import net.square.sierra.packetevents.api.adventure.serializer.gson.BackwardCompatUtil;
import net.square.sierra.packetevents.api.adventure.serializer.gson.BlockNBTComponentPosSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.ClickEventActionSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.ComponentSerializerImpl;
import net.square.sierra.packetevents.api.adventure.serializer.gson.HoverEventActionSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.KeySerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.ShowEntitySerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.ShowItemSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.StyleSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.TextColorSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.TextColorWrapper;
import net.square.sierra.packetevents.api.adventure.serializer.gson.TextDecorationSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.TranslationArgumentSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.gson.UUIDSerializer;
import net.square.sierra.packetevents.api.adventure.serializer.json.JSONOptions;
import net.square.sierra.packetevents.api.adventure.serializer.json.LegacyHoverEventSerializer;
import org.jetbrains.annotations.Nullable;

final class SerializerFactory
implements TypeAdapterFactory {
    static final Class<Key> KEY_TYPE = Key.class;
    static final Class<Component> COMPONENT_TYPE = Component.class;
    static final Class<Style> STYLE_TYPE = Style.class;
    static final Class<ClickEvent.Action> CLICK_ACTION_TYPE = ClickEvent.Action.class;
    static final Class<HoverEvent.Action> HOVER_ACTION_TYPE = HoverEvent.Action.class;
    static final Class<HoverEvent.ShowItem> SHOW_ITEM_TYPE = HoverEvent.ShowItem.class;
    static final Class<HoverEvent.ShowEntity> SHOW_ENTITY_TYPE = HoverEvent.ShowEntity.class;
    static final Class<String> STRING_TYPE = String.class;
    static final Class<TextColorWrapper> COLOR_WRAPPER_TYPE = TextColorWrapper.class;
    static final Class<TextColor> COLOR_TYPE = TextColor.class;
    static final Class<TextDecoration> TEXT_DECORATION_TYPE = TextDecoration.class;
    static final Class<BlockNBTComponent.Pos> BLOCK_NBT_POS_TYPE = BlockNBTComponent.Pos.class;
    static final Class<UUID> UUID_TYPE = UUID.class;
    static final Class<?> TRANSLATION_ARGUMENT_TYPE = BackwardCompatUtil.IS_4_15_0_OR_NEWER ? TranslationArgument.class : null;
    private final OptionState features;
    private final LegacyHoverEventSerializer legacyHoverSerializer;
    private final BackwardCompatUtil.ShowAchievementToComponent compatShowAchievement;

    SerializerFactory(OptionState features, @Nullable LegacyHoverEventSerializer legacyHoverSerializer, @Nullable BackwardCompatUtil.ShowAchievementToComponent compatShowAchievement) {
        this.features = features;
        this.legacyHoverSerializer = legacyHoverSerializer;
        this.compatShowAchievement = compatShowAchievement;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (COMPONENT_TYPE.isAssignableFrom(rawType)) {
            return ComponentSerializerImpl.create(this.features, gson);
        }
        if (KEY_TYPE.isAssignableFrom(rawType)) {
            return KeySerializer.INSTANCE;
        }
        if (STYLE_TYPE.isAssignableFrom(rawType)) {
            return StyleSerializer.create(this.legacyHoverSerializer, this.compatShowAchievement, this.features, gson);
        }
        if (CLICK_ACTION_TYPE.isAssignableFrom(rawType)) {
            return ClickEventActionSerializer.INSTANCE;
        }
        if (HOVER_ACTION_TYPE.isAssignableFrom(rawType)) {
            return HoverEventActionSerializer.INSTANCE;
        }
        if (SHOW_ITEM_TYPE.isAssignableFrom(rawType)) {
            return ShowItemSerializer.create(gson, this.features);
        }
        if (SHOW_ENTITY_TYPE.isAssignableFrom(rawType)) {
            return ShowEntitySerializer.create(gson);
        }
        if (COLOR_WRAPPER_TYPE.isAssignableFrom(rawType)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (COLOR_TYPE.isAssignableFrom(rawType)) {
            return this.features.value(JSONOptions.EMIT_RGB) != false ? TextColorSerializer.INSTANCE : TextColorSerializer.DOWNSAMPLE_COLOR;
        }
        if (TEXT_DECORATION_TYPE.isAssignableFrom(rawType)) {
            return TextDecorationSerializer.INSTANCE;
        }
        if (BLOCK_NBT_POS_TYPE.isAssignableFrom(rawType)) {
            return BlockNBTComponentPosSerializer.INSTANCE;
        }
        if (BackwardCompatUtil.IS_4_15_0_OR_NEWER) {
            if (UUID_TYPE.isAssignableFrom(rawType)) {
                return UUIDSerializer.uuidSerializer(this.features);
            }
            if (TRANSLATION_ARGUMENT_TYPE.isAssignableFrom(rawType)) {
                return TranslationArgumentSerializer.create(gson);
            }
        }
        return null;
    }
}

