/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.manager;

import java.net.InetSocketAddress;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.manager.InternalPacketListener;
import net.square.sierra.packetevents.api.protocol.ConnectionState;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.player.User;
import net.square.sierra.packetevents.api.util.protocolsupport.ProtocolSupportUtil;
import net.square.sierra.packetevents.api.util.viaversion.ViaVersionUtil;
import net.square.sierra.packetevents.api.wrapper.handshaking.client.WrapperHandshakingClientHandshake;

public class InternalBukkitPacketListener
extends InternalPacketListener {
    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            InetSocketAddress address = event.getSocketAddress();
            WrapperHandshakingClientHandshake handshake = new WrapperHandshakingClientHandshake(event);
            ConnectionState nextState = handshake.getNextConnectionState();
            ClientVersion clientVersion = handshake.getClientVersion();
            PacketEvents.getAPI().getLogManager().debug("Read handshake version for " + address.getHostString() + ":" + address.getPort() + " as " + (Object)((Object)clientVersion));
            if (ViaVersionUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ViaVersionUtil.getProtocolVersion(user));
                PacketEvents.getAPI().getLogManager().debug("Read ViaVersion version for " + address.getHostString() + ":" + address.getPort() + " as " + (Object)((Object)clientVersion) + " with UUID=" + user.getUUID());
            } else if (ProtocolSupportUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ProtocolSupportUtil.getProtocolVersion(user.getAddress()));
                PacketEvents.getAPI().getLogManager().debug("Read ProtocolSupport version for " + address.getHostString() + ":" + address.getPort() + " as " + (Object)((Object)clientVersion));
            }
            if (clientVersion == ClientVersion.UNKNOWN) {
                PacketEvents.getAPI().getLogManager().debug("Client version for " + address.getHostString() + ":" + address.getPort() + " is unknown!");
            }
            user.setClientVersion(clientVersion);
            PacketEvents.getAPI().getLogManager().debug("Processed " + address.getHostString() + ":" + address.getPort() + "'s client version. Client Version: " + clientVersion.getReleaseName());
            user.setConnectionState(nextState);
        } else {
            super.onPacketReceive(event);
        }
    }
}

