/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.component;

import net.square.sierra.packetevents.api.protocol.component.ComponentType;
import net.square.sierra.packetevents.api.protocol.mapper.AbstractMappedEntity;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class StaticComponentType<T>
extends AbstractMappedEntity
implements ComponentType<T> {
    @Nullable
    private final PacketWrapper.Reader<T> reader;
    @Nullable
    private final PacketWrapper.Writer<T> writer;
    @Nullable
    private final ComponentType.Decoder<T> decoder;
    @Nullable
    private final ComponentType.Encoder<T> encoder;

    public StaticComponentType(@Nullable TypesBuilderData data, @Nullable PacketWrapper.Reader<T> reader, @Nullable PacketWrapper.Writer<T> writer) {
        this(data, reader, writer, null, null);
    }

    public StaticComponentType(@Nullable TypesBuilderData data, @Nullable ComponentType.Decoder<T> decoder, @Nullable ComponentType.Encoder<T> encoder) {
        this(data, null, null, decoder, encoder);
    }

    public StaticComponentType(@Nullable TypesBuilderData data, @Nullable PacketWrapper.Reader<T> reader, @Nullable PacketWrapper.Writer<T> writer, @Nullable ComponentType.Decoder<T> decoder, @Nullable ComponentType.Encoder<T> encoder) {
        super(data);
        this.reader = reader;
        this.writer = writer;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public T read(PacketWrapper<?> wrapper) {
        return this.reader != null ? (T)this.reader.apply(wrapper) : null;
    }

    @Override
    public void write(PacketWrapper<?> wrapper, T content) {
        if (this.writer != null) {
            this.writer.accept(wrapper, content);
        }
    }

    @Override
    public T decode(NBT nbt, ClientVersion version) {
        if (this.decoder != null) {
            return this.decoder.decode(nbt, version);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public NBT encode(T value, ClientVersion version) {
        if (this.encoder != null) {
            return this.encoder.encode(value, version);
        }
        throw new UnsupportedOperationException();
    }
}

