/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.component.builtin.item;

import java.util.Objects;
import net.square.sierra.packetevents.api.protocol.item.jukebox.IJukeboxSong;
import net.square.sierra.packetevents.api.protocol.item.jukebox.JukeboxSong;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemJukeboxPlayable {
    @Nullable
    private IJukeboxSong song;
    @Nullable
    private ResourceLocation songKey;
    private boolean showInTooltip;

    public ItemJukeboxPlayable(@Nullable JukeboxSong song, @Nullable ResourceLocation songKey, boolean showInTooltip) {
        this((IJukeboxSong)song, songKey, showInTooltip);
    }

    public ItemJukeboxPlayable(@Nullable IJukeboxSong song, @Nullable ResourceLocation songKey, boolean showInTooltip) {
        if (song == null == (songKey == null)) {
            throw new IllegalStateException("Illegal state of both song and song key combined: " + song + " / " + songKey);
        }
        this.song = song;
        this.songKey = songKey;
        this.showInTooltip = showInTooltip;
    }

    public static ItemJukeboxPlayable read(PacketWrapper<?> wrapper) {
        ResourceLocation songKey;
        IJukeboxSong song;
        if (wrapper.readBoolean()) {
            song = IJukeboxSong.read(wrapper);
            songKey = null;
        } else {
            song = null;
            songKey = wrapper.readIdentifier();
        }
        boolean showInTooltip = wrapper.readBoolean();
        return new ItemJukeboxPlayable(song, songKey, showInTooltip);
    }

    public static void write(PacketWrapper<?> wrapper, ItemJukeboxPlayable jukeboxPlayable) {
        if (jukeboxPlayable.song != null) {
            wrapper.writeBoolean(true);
            IJukeboxSong.write(wrapper, jukeboxPlayable.song);
        } else {
            assert (jukeboxPlayable.songKey != null);
            wrapper.writeBoolean(false);
            wrapper.writeIdentifier(jukeboxPlayable.songKey);
        }
        wrapper.writeBoolean(jukeboxPlayable.showInTooltip);
    }

    @Nullable
    public IJukeboxSong getJukeboxSong() {
        return this.song;
    }

    public void setJukeboxSong(@Nullable JukeboxSong song) {
        this.song = song;
        this.songKey = null;
    }

    @Deprecated
    @Nullable
    public JukeboxSong getSong() {
        if (this.song == null) {
            return null;
        }
        if (this.song instanceof JukeboxSong) {
            return (JukeboxSong)this.song;
        }
        return (JukeboxSong)this.song.copy(null);
    }

    @Deprecated
    public void setSong(JukeboxSong song) {
        this.song = song;
        this.songKey = null;
    }

    @Nullable
    public ResourceLocation getSongKey() {
        return this.songKey;
    }

    public void setSongKey(ResourceLocation songKey) {
        this.song = null;
        this.songKey = songKey;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public void setShowInTooltip(boolean showInTooltip) {
        this.showInTooltip = showInTooltip;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemJukeboxPlayable)) {
            return false;
        }
        ItemJukeboxPlayable that = (ItemJukeboxPlayable)obj;
        if (this.showInTooltip != that.showInTooltip) {
            return false;
        }
        if (!Objects.equals(this.song, that.song)) {
            return false;
        }
        return Objects.equals(this.songKey, that.songKey);
    }

    public int hashCode() {
        return Objects.hash(this.song, this.songKey, this.showInTooltip);
    }
}

