/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.component.builtin.item;

import java.util.List;
import java.util.Objects;
import net.square.sierra.packetevents.api.protocol.potion.Potion;
import net.square.sierra.packetevents.api.protocol.potion.PotionEffect;
import net.square.sierra.packetevents.api.protocol.potion.Potions;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemPotionContents {
    @Nullable
    private Potion potion;
    @Nullable
    private Integer customColor;
    private List<PotionEffect> customEffects;

    public ItemPotionContents(@Nullable Potion potion, @Nullable Integer customColor, List<PotionEffect> customEffects) {
        this.potion = potion;
        this.customColor = customColor;
        this.customEffects = customEffects;
    }

    public static ItemPotionContents read(PacketWrapper<?> wrapper) {
        Potion potionId = (Potion)wrapper.readOptional(ew -> ew.readMappedEntity(Potions::getById));
        Integer customColor = (Integer)wrapper.readOptional(PacketWrapper::readInt);
        List<PotionEffect> customEffects = wrapper.readList(PotionEffect::read);
        return new ItemPotionContents(potionId, customColor, customEffects);
    }

    public static void write(PacketWrapper<?> wrapper, ItemPotionContents contents) {
        wrapper.writeOptional(contents.potion, PacketWrapper::writeMappedEntity);
        wrapper.writeOptional(contents.customColor, PacketWrapper::writeInt);
        wrapper.writeList(contents.customEffects, PotionEffect::write);
    }

    @Nullable
    public Potion getPotion() {
        return this.potion;
    }

    public void setPotion(@Nullable Potion potion) {
        this.potion = potion;
    }

    @Nullable
    public Integer getCustomColor() {
        return this.customColor;
    }

    public void setCustomColor(@Nullable Integer customColor) {
        this.customColor = customColor;
    }

    private void addCustomEffect(PotionEffect effect) {
        this.customEffects.add(effect);
    }

    public List<PotionEffect> getCustomEffects() {
        return this.customEffects;
    }

    public void setCustomEffects(List<PotionEffect> customEffects) {
        this.customEffects = customEffects;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemPotionContents)) {
            return false;
        }
        ItemPotionContents that = (ItemPotionContents)obj;
        if (!Objects.equals(this.potion, that.potion)) {
            return false;
        }
        if (!Objects.equals(this.customColor, that.customColor)) {
            return false;
        }
        return this.customEffects.equals(that.customEffects);
    }

    public int hashCode() {
        return Objects.hash(this.potion, this.customColor, this.customEffects);
    }
}

