/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.component.builtin.item;

import java.util.List;
import java.util.Objects;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public class ItemRecipes {
    private List<ResourceLocation> recipes;

    public ItemRecipes(List<ResourceLocation> recipes) {
        this.recipes = recipes;
    }

    public static ItemRecipes read(PacketWrapper<?> wrapper) {
        List<ResourceLocation> recipes = wrapper.readList(PacketWrapper::readIdentifier);
        return new ItemRecipes(recipes);
    }

    public static void write(PacketWrapper<?> wrapper, ItemRecipes recipes) {
        wrapper.writeList(recipes.recipes, PacketWrapper::writeIdentifier);
    }

    public void addRecipe(ResourceLocation recipeKey) {
        this.recipes.add(recipeKey);
    }

    public void removeRecipe(ResourceLocation recipeKey) {
        this.recipes.remove(recipeKey);
    }

    public List<ResourceLocation> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(List<ResourceLocation> recipes) {
        this.recipes = recipes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemRecipes)) {
            return false;
        }
        ItemRecipes that = (ItemRecipes)obj;
        return this.recipes.equals(that.recipes);
    }

    public int hashCode() {
        return Objects.hashCode(this.recipes);
    }
}

