/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.entity.wolfvariant;

import java.util.Objects;
import net.square.sierra.packetevents.api.protocol.entity.wolfvariant.WolfVariant;
import net.square.sierra.packetevents.api.protocol.mapper.AbstractMappedEntity;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntitySet;
import net.square.sierra.packetevents.api.protocol.world.biome.Biome;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.Nullable;

public class StaticWolfVariant
extends AbstractMappedEntity
implements WolfVariant {
    private final ResourceLocation wildTexture;
    private final ResourceLocation tameTexture;
    private final ResourceLocation angryTexture;
    private final MappedEntitySet<Biome> biomes;

    public StaticWolfVariant(ResourceLocation wildTexture, ResourceLocation tameTexture, ResourceLocation angryTexture, MappedEntitySet<Biome> biomes) {
        this(null, wildTexture, tameTexture, angryTexture, biomes);
    }

    public StaticWolfVariant(@Nullable TypesBuilderData data, ResourceLocation wildTexture, ResourceLocation tameTexture, ResourceLocation angryTexture, MappedEntitySet<Biome> biomes) {
        super(data);
        this.wildTexture = wildTexture;
        this.tameTexture = tameTexture;
        this.angryTexture = angryTexture;
        this.biomes = biomes;
    }

    @Override
    public WolfVariant copy(@Nullable TypesBuilderData newData) {
        return new StaticWolfVariant(newData, this.wildTexture, this.tameTexture, this.angryTexture, this.biomes);
    }

    @Override
    public ResourceLocation getWildTexture() {
        return this.wildTexture;
    }

    @Override
    public ResourceLocation getTameTexture() {
        return this.tameTexture;
    }

    @Override
    public ResourceLocation getAngryTexture() {
        return this.angryTexture;
    }

    @Override
    public MappedEntitySet<Biome> getBiomes() {
        return this.biomes;
    }

    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticWolfVariant)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticWolfVariant that = (StaticWolfVariant)obj;
        if (!this.wildTexture.equals(that.wildTexture)) {
            return false;
        }
        if (!this.tameTexture.equals(that.tameTexture)) {
            return false;
        }
        if (!this.angryTexture.equals(that.angryTexture)) {
            return false;
        }
        return this.biomes.equals(that.biomes);
    }

    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.wildTexture, this.tameTexture, this.angryTexture, this.biomes);
    }

    public String toString() {
        return "StaticWolfVariant{wildTexture=" + this.wildTexture + ", tameTexture=" + this.tameTexture + ", angryTexture=" + this.angryTexture + ", biomes=" + this.biomes + '}';
    }
}

