/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.square.sierra.packetevents.api.protocol.component.ComponentType;
import net.square.sierra.packetevents.api.protocol.component.ComponentTypes;
import net.square.sierra.packetevents.api.protocol.component.PatchableComponentMap;
import net.square.sierra.packetevents.api.protocol.component.StaticComponentMap;
import net.square.sierra.packetevents.api.protocol.component.builtin.item.ItemEnchantments;
import net.square.sierra.packetevents.api.protocol.item.enchantment.Enchantment;
import net.square.sierra.packetevents.api.protocol.item.enchantment.type.EnchantmentType;
import net.square.sierra.packetevents.api.protocol.item.enchantment.type.EnchantmentTypes;
import net.square.sierra.packetevents.api.protocol.item.type.ItemType;
import net.square.sierra.packetevents.api.protocol.item.type.ItemTypes;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTInt;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;
import net.square.sierra.packetevents.api.protocol.nbt.NBTShort;
import net.square.sierra.packetevents.api.protocol.nbt.NBTString;
import net.square.sierra.packetevents.api.protocol.nbt.NBTType;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ItemStack {
    public static final ItemStack EMPTY = new ItemStack(ItemTypes.AIR, 0, new NBTCompound(), 0);
    private final ItemType type;
    private int amount;
    @Nullable
    private NBTCompound nbt;
    @Nullable
    private PatchableComponentMap components;
    private int legacyData = -1;
    private boolean cachedIsEmpty = false;

    private ItemStack(ItemType type, int amount, @Nullable NBTCompound nbt, int legacyData) {
        this(type, amount, nbt, null, legacyData);
    }

    private ItemStack(ItemType type, int amount, @Nullable NBTCompound nbt, @Nullable PatchableComponentMap components, int legacyData) {
        this.type = type;
        this.amount = amount;
        this.nbt = nbt;
        this.components = components;
        this.legacyData = legacyData;
        this.updateCachedEmptyStatus();
    }

    public static ItemStack decode(NBT nbt, ClientVersion version) {
        if (nbt instanceof NBTString) {
            ResourceLocation itemName = new ResourceLocation(((NBTString)nbt).getValue());
            return ItemStack.builder().type(ItemTypes.getByName(itemName.toString())).build();
        }
        NBTCompound compound = (NBTCompound)nbt;
        Builder builder = ItemStack.builder();
        ResourceLocation itemName = Optional.ofNullable(compound.getStringTagValueOrNull("id")).map(Optional::of).orElseGet(() -> Optional.ofNullable(compound.getStringTagValueOrNull("item"))).map(ResourceLocation::new).orElseThrow(() -> new IllegalArgumentException("No item type specified: " + compound.getTags().keySet()));
        builder.type(ItemTypes.getByName(itemName.toString()));
        builder.nbt(compound.getCompoundTagOrNull("tag"));
        Optional.ofNullable(compound.getNumberTagOrNull("Count")).map(Optional::of).orElseGet(() -> Optional.ofNullable(compound.getNumberTagOrNull("count"))).map(NBTNumber::getAsInt).ifPresent(builder::amount);
        return builder.build();
    }

    public static NBT encodeForParticle(ItemStack itemStack, ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            boolean simple;
            boolean bl = simple = itemStack.isEmpty() || itemStack.components == null || itemStack.components.getPatches().isEmpty();
            if (simple) {
                return new NBTString(itemStack.type.getName().toString());
            }
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("id", new NBTString(itemStack.type.getName().toString()));
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            compound.setTag("Count", new NBTInt(itemStack.amount));
            if (itemStack.nbt != null) {
                compound.setTag("tag", itemStack.nbt);
            }
        }
        return compound;
    }

    public int getMaxStackSize() {
        return this.getComponentOr(ComponentTypes.MAX_STACK_SIZE, this.getType().getMaxAmount());
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return !this.cachedIsEmpty && this.getMaxDamage() > 0 && (this.nbt == null || !this.nbt.getBoolean("Unbreakable")) && this.getComponentOr(ComponentTypes.UNBREAKABLE, false) == false;
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        NBTInt damage;
        if (this.nbt != null && (damage = this.nbt.getTagOfTypeOrNull("Damage", NBTInt.class)) != null) {
            return damage.getAsInt();
        }
        return this.getComponentOr(ComponentTypes.DAMAGE, 0);
    }

    public void setDamageValue(int damage) {
        int cappedDamage = Math.max(0, damage);
        this.getOrCreateTag().setTag("Damage", new NBTInt(cappedDamage));
        this.setComponent(ComponentTypes.DAMAGE, cappedDamage);
    }

    public int getMaxDamage() {
        return this.getComponentOr(ComponentTypes.MAX_DAMAGE, this.getType().getMaxDurability());
    }

    public NBTCompound getOrCreateTag() {
        if (this.nbt == null) {
            this.nbt = new NBTCompound();
        }
        return this.nbt;
    }

    private void updateCachedEmptyStatus() {
        this.cachedIsEmpty = this.isEmpty();
    }

    public ItemType getType() {
        return this.cachedIsEmpty ? ItemTypes.AIR : this.type;
    }

    public int getAmount() {
        return this.cachedIsEmpty ? 0 : this.amount;
    }

    public void shrink(int amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public void grow(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.updateCachedEmptyStatus();
    }

    public ItemStack split(int toTake) {
        int i = Math.min(toTake, this.getAmount());
        ItemStack itemstack = this.copy();
        itemstack.setAmount(i);
        this.shrink(i);
        return itemstack;
    }

    public ItemStack copy() {
        return this.cachedIsEmpty ? EMPTY : new ItemStack(this.type, this.amount, this.nbt == null ? null : this.nbt.copy(), this.components == null ? null : this.components.copy(), this.legacyData);
    }

    @Nullable
    public NBTCompound getNBT() {
        return this.nbt;
    }

    public void setNBT(NBTCompound nbt) {
        this.nbt = nbt;
    }

    public <T> T getComponentOr(ComponentType<T> type, T otherValue) {
        if (this.hasComponentPatches()) {
            return this.getComponents().getOr(type, otherValue);
        }
        return this.getType().getComponents().getOr(type, otherValue);
    }

    public <T> Optional<T> getComponent(ComponentType<T> type) {
        if (this.hasComponentPatches()) {
            return this.getComponents().getOptional(type);
        }
        return this.getType().getComponents().getOptional(type);
    }

    public <T> void setComponent(ComponentType<T> type, T value) {
        this.getComponents().set(type, value);
    }

    public <T> void unsetComponent(ComponentType<T> type) {
        this.getComponents().unset(type);
    }

    public <T> void setComponent(ComponentType<T> type, Optional<T> value) {
        this.getComponents().set(type, value);
    }

    public boolean hasComponent(ComponentType<?> type) {
        if (this.hasComponentPatches()) {
            return this.getComponents().has(type);
        }
        return this.getType().getComponents().has(type);
    }

    public boolean hasComponentPatches() {
        return this.components != null && !this.components.getPatches().isEmpty();
    }

    public PatchableComponentMap getComponents() {
        if (this.components == null) {
            this.components = new PatchableComponentMap(this.type.getComponents(), new HashMap(4));
        }
        return this.components;
    }

    public void setComponents(@Nullable PatchableComponentMap components) {
        this.components = components;
    }

    public int getLegacyData() {
        return this.legacyData;
    }

    public void setLegacyData(int legacyData) {
        this.legacyData = legacyData;
    }

    public boolean isEnchantable(ClientVersion version) {
        if (this.getType() == ItemTypes.BOOK) {
            return this.getAmount() == 1;
        }
        if (this.getType() == ItemTypes.ENCHANTED_BOOK) {
            return false;
        }
        return this.getMaxStackSize() == 1 && this.canBeDepleted() && !this.isEnchanted(version);
    }

    public boolean isEnchanted(ClientVersion version) {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.getComponentOr(ComponentTypes.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !this.getComponentOr(ComponentTypes.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty()) {
            return true;
        }
        if (this.nbt != null) {
            String tagName = this.getEnchantmentsTagName(version);
            NBTList<NBTCompound> enchantments = this.nbt.getCompoundListTagOrNull(tagName);
            return enchantments != null && !enchantments.getTags().isEmpty();
        }
        return false;
    }

    public List<Enchantment> getEnchantments(ClientVersion version) {
        String tagName;
        NBTList<NBTCompound> nbtList;
        if (this.isEmpty()) {
            return new ArrayList<Enchantment>(0);
        }
        ItemEnchantments enchantmentsComp = this.getComponentOr(ComponentTypes.ENCHANTMENTS, ItemEnchantments.EMPTY);
        ItemEnchantments storedEnchantmentsComp = this.getComponentOr(ComponentTypes.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY);
        if (!enchantmentsComp.isEmpty() || !storedEnchantmentsComp.isEmpty()) {
            ArrayList<Enchantment> enchantmentsList = new ArrayList<Enchantment>(enchantmentsComp.getEnchantmentCount() + storedEnchantmentsComp.getEnchantmentCount());
            for (Map.Entry<EnchantmentType, Integer> enchantment : enchantmentsComp) {
                enchantmentsList.add(new Enchantment(enchantment.getKey(), enchantment.getValue()));
            }
            for (Map.Entry<EnchantmentType, Integer> enchantment : storedEnchantmentsComp) {
                enchantmentsList.add(new Enchantment(enchantment.getKey(), enchantment.getValue()));
            }
            return enchantmentsList;
        }
        if (this.nbt != null && (nbtList = this.nbt.getCompoundListTagOrNull(tagName = this.getEnchantmentsTagName(version))) != null) {
            List<NBTCompound> compounds = nbtList.getTags();
            ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>(compounds.size());
            for (NBTCompound compound : compounds) {
                EnchantmentType type = ItemStack.getEnchantmentTypeFromTag(compound, version);
                if (type == null) continue;
                NBTShort levelTag = compound.getTagOfTypeOrNull("lvl", NBTShort.class);
                int level = levelTag.getAsInt();
                Enchantment enchantment = Enchantment.builder().type(type).level(level).build();
                enchantments.add(enchantment);
            }
            return enchantments;
        }
        return new ArrayList<Enchantment>(0);
    }

    public int getEnchantmentLevel(EnchantmentType enchantment, ClientVersion version) {
        String tagName;
        NBTList<NBTCompound> nbtList;
        int level;
        int level2;
        if (this.isEmpty()) {
            return 0;
        }
        ItemEnchantments enchantmentsComp = this.getComponentOr(ComponentTypes.ENCHANTMENTS, ItemEnchantments.EMPTY);
        if (!enchantmentsComp.isEmpty() && (level2 = enchantmentsComp.getEnchantmentLevel(enchantment)) > 0) {
            return level2;
        }
        ItemEnchantments storedEnchantmentsComp = this.getComponentOr(ComponentTypes.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY);
        if (!storedEnchantmentsComp.isEmpty() && (level = storedEnchantmentsComp.getEnchantmentLevel(enchantment)) > 0) {
            return level;
        }
        if (this.nbt != null && (nbtList = this.nbt.getCompoundListTagOrNull(tagName = this.getEnchantmentsTagName(version))) != null) {
            for (NBTCompound base : nbtList.getTags()) {
                EnchantmentType type = ItemStack.getEnchantmentTypeFromTag(base, version);
                if (enchantment != type) continue;
                NBTShort nbtShort = base.getTagOfTypeOrNull("lvl", NBTShort.class);
                return nbtShort != null ? nbtShort.getAsInt() : 0;
            }
        }
        return 0;
    }

    @Nullable
    private static EnchantmentType getEnchantmentTypeFromTag(NBTCompound tag, ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_13)) {
            String id = tag.getStringTagValueOrNull("id");
            return EnchantmentTypes.getByName(id);
        }
        NBTShort idTag = tag.getTagOfTypeOrNull("id", NBTShort.class);
        return EnchantmentTypes.getById(version, idTag.getAsInt());
    }

    public void setEnchantments(List<Enchantment> enchantments, ClientVersion version) {
        this.nbt = this.getOrCreateTag();
        String tagName = this.getEnchantmentsTagName(version);
        if (enchantments.isEmpty()) {
            if (this.nbt.getTagOrNull(tagName) != null) {
                this.nbt.removeTag(tagName);
            }
        } else {
            ArrayList<NBTCompound> list = new ArrayList<NBTCompound>();
            for (Enchantment enchantment : enchantments) {
                NBTCompound compound = new NBTCompound();
                if (version.isNewerThanOrEquals(ClientVersion.V_1_13)) {
                    compound.setTag("id", new NBTString(enchantment.getType().getName().toString()));
                } else {
                    compound.setTag("id", new NBTShort((short)enchantment.getType().getId(version)));
                }
                compound.setTag("lvl", new NBTShort((short)enchantment.getLevel()));
                list.add(compound);
            }
            assert (this.nbt != null);
            this.nbt.setTag(tagName, new NBTList<NBTCompound>(NBTType.COMPOUND, list));
        }
        HashMap<EnchantmentType, Integer> enchantmentsMap = new HashMap<EnchantmentType, Integer>(enchantments.size());
        for (Enchantment enchantment : enchantments) {
            enchantmentsMap.put(enchantment.getType(), enchantment.getLevel());
        }
        ComponentType<ItemEnchantments> componentType = this.type == ItemTypes.ENCHANTED_BOOK ? ComponentTypes.STORED_ENCHANTMENTS : ComponentTypes.ENCHANTMENTS;
        Optional<ItemEnchantments> prevEnchantments = this.getComponent(componentType);
        boolean showInTooltip = prevEnchantments.map(ItemEnchantments::isShowInTooltip).orElse(true);
        this.setComponent(componentType, new ItemEnchantments(enchantmentsMap, showInTooltip));
    }

    @Deprecated
    public String getEnchantmentsTagName(ClientVersion version) {
        String tagName;
        String string = tagName = version.isNewerThanOrEquals(ClientVersion.V_1_13) ? "Enchantments" : "ench";
        if (this.type == ItemTypes.ENCHANTED_BOOK) {
            tagName = "StoredEnchantments";
        }
        return tagName;
    }

    public boolean canBeDepleted() {
        return this.getType().getMaxDurability() > 0;
    }

    public boolean is(ItemType type) {
        return this.getType() == type;
    }

    public static boolean isSameItemSameTags(ItemStack stack, ItemStack otherStack) {
        return stack.is(otherStack.getType()) && (stack.isEmpty() && otherStack.isEmpty() || ItemStack.tagMatches(stack, otherStack) && Objects.equals(stack.components, otherStack.components));
    }

    public static boolean tagMatches(ItemStack left, ItemStack right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right.isEmpty();
        }
        if (right == null) {
            return left.isEmpty();
        }
        return Objects.equals(left.nbt, right.nbt) && Objects.equals(left.components, right.components);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            return this.getType().equals(itemStack.getType()) && this.amount == itemStack.amount && Objects.equals(this.nbt, itemStack.nbt) && Objects.equals(this.components, itemStack.components) && this.legacyData == itemStack.legacyData;
        }
        return false;
    }

    public String toString() {
        if (this.cachedIsEmpty) {
            return "ItemStack[null]";
        }
        String identifier = this.type == null ? "null" : this.type.getName().toString();
        int maxAmount = this.getType().getMaxAmount();
        return "ItemStack[type=" + identifier + ", amount=" + this.amount + "/" + maxAmount + ", nbt tag names: " + (this.nbt != null ? this.nbt.getTagNames() : "[null]") + ", legacyData=" + this.legacyData + ", components=" + this.components + "]";
    }

    public boolean isEmpty() {
        return this.type == null || this.type == ItemTypes.AIR || this.amount <= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ItemType type;
        private int amount = 1;
        private NBTCompound nbt = null;
        private PatchableComponentMap components = null;
        private int legacyData = -1;

        public Builder type(ItemType type) {
            this.type = type;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder nbt(NBTCompound nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder nbt(String key, NBT tag) {
            if (this.nbt == null) {
                this.nbt = new NBTCompound();
            }
            this.nbt.setTag(key, tag);
            return this;
        }

        public Builder components(@Nullable PatchableComponentMap components) {
            this.components = components;
            return this;
        }

        public <T> Builder component(ComponentType<T> type, @Nullable T value) {
            if (this.components == null) {
                this.components = new PatchableComponentMap(this.type == null ? StaticComponentMap.SHARED_ITEM_COMPONENTS : this.type.getComponents());
            }
            this.components.set(type, value);
            return this;
        }

        public Builder legacyData(int legacyData) {
            this.legacyData = legacyData;
            return this;
        }

        public ItemStack build() {
            return new ItemStack(this.type, this.amount, this.nbt, this.components, this.legacyData);
        }
    }
}

