/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.item.enchantment.type;

import java.util.Optional;
import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.packetevents.api.protocol.component.EnchantEffectComponentTypes;
import net.square.sierra.packetevents.api.protocol.component.IComponentMap;
import net.square.sierra.packetevents.api.protocol.component.StaticComponentMap;
import net.square.sierra.packetevents.api.protocol.item.enchantment.EnchantmentDefinition;
import net.square.sierra.packetevents.api.protocol.item.enchantment.type.EnchantmentTypes;
import net.square.sierra.packetevents.api.protocol.item.enchantment.type.StaticEnchantmentType;
import net.square.sierra.packetevents.api.protocol.mapper.CopyableEntity;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntitySet;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.util.adventure.AdventureSerializer;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.Nullable;

public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType> {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public StaticComponentMap getEffects();

    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        EnchantmentDefinition definition = EnchantmentDefinition.decode(compound, version);
        MappedEntitySet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decode(tag, version, EnchantmentTypes.getRegistry())).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, version, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    public static NBT encode(EnchantmentType type, ClientVersion version) {
        NBTCompound compound = (NBTCompound)EnchantmentDefinition.encode(type.getDefinition(), version);
        compound.setTag("description", AdventureSerializer.toNbt(type.getDescription()));
        if (!type.getExclusiveSet().isEmpty()) {
            compound.setTag("exclusive_set", MappedEntitySet.encode(type.getExclusiveSet(), version));
        }
        if (!type.getEffects().isEmpty()) {
            compound.setTag("effects", IComponentMap.encode(type.getEffects(), version));
        }
        return compound;
    }
}

