/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.item.instrument;

import net.square.sierra.packetevents.api.protocol.item.instrument.Instruments;
import net.square.sierra.packetevents.api.protocol.item.instrument.StaticInstrument;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.sound.Sound;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public interface Instrument
extends MappedEntity {
    public Sound getSound();

    public int getUseDuration();

    public float getRange();

    public static Instrument read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Instruments::getById, Instrument::readDirect);
    }

    public static Instrument readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        int useDuration = wrapper.readVarInt();
        float range = wrapper.readFloat();
        return new StaticInstrument(sound, useDuration, range);
    }

    public static void write(PacketWrapper<?> wrapper, Instrument instrument) {
        wrapper.writeMappedEntityOrDirect(instrument, Instrument::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Instrument instrument) {
        Sound.write(wrapper, instrument.getSound());
        wrapper.writeVarInt(instrument.getUseDuration());
        wrapper.writeFloat(instrument.getRange());
    }
}

