/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.item.instrument;

import java.util.HashMap;
import java.util.Map;
import net.square.sierra.packetevents.api.protocol.item.instrument.Instrument;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.sound.Sound;
import net.square.sierra.packetevents.api.protocol.sound.Sounds;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.mappings.MappingHelper;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilder;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;

public class Instruments {
    private static final Map<String, Instrument> INSTRUMENT_MAP = new HashMap<String, Instrument>();
    private static final Map<Byte, Map<Integer, Instrument>> INSTRUMENT_ID_MAP = new HashMap<Byte, Map<Integer, Instrument>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_instrument_mappings");
    public static final Instrument PONDER_GOAT_HORN = Instruments.define("ponder_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_0);
    public static final Instrument SING_GOAT_HORN = Instruments.define("sing_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_1);
    public static final Instrument SEEK_GOAT_HORN = Instruments.define("seek_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_2);
    public static final Instrument FEEL_GOAT_HORN = Instruments.define("feel_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_3);
    public static final Instrument ADMIRE_GOAT_HORN = Instruments.define("admire_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_4);
    public static final Instrument CALL_GOAT_HORN = Instruments.define("call_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_5);
    public static final Instrument YEARN_GOAT_HORN = Instruments.define("yearn_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_6);
    public static final Instrument DREAM_GOAT_HORN = Instruments.define("dream_goat_horn", Sounds.ITEM_GOAT_HORN_SOUND_7);

    public static Instrument define(String key, Sound sound) {
        return Instruments.define(key, sound, 140, 256.0f);
    }

    public static Instrument define(String key, final Sound sound, final int useDuration, final float range) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        Instrument instrument = new Instrument(){

            @Override
            public Sound getSound() {
                return sound;
            }

            @Override
            public int getUseDuration() {
                return useDuration;
            }

            @Override
            public float getRange() {
                return range;
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof Instrument) {
                    return this.getName().equals(((Instrument)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, INSTRUMENT_MAP, INSTRUMENT_ID_MAP, instrument);
        return instrument;
    }

    public static Instrument getByName(String name) {
        return INSTRUMENT_MAP.get(name);
    }

    public static Instrument getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, Instrument> idMap = INSTRUMENT_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

