/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.item.instrument;

import java.util.Objects;
import net.square.sierra.packetevents.api.protocol.item.instrument.Instrument;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.sound.Sound;
import net.square.sierra.packetevents.api.resources.ResourceLocation;

public class StaticInstrument
implements Instrument {
    private final Sound sound;
    private final int useDuration;
    private final float range;

    public StaticInstrument(Sound sound, int useDuration, float range) {
        this.sound = sound;
        this.useDuration = useDuration;
        this.range = range;
    }

    @Override
    public Sound getSound() {
        return this.sound;
    }

    @Override
    public int getUseDuration() {
        return this.useDuration;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public ResourceLocation getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getId(ClientVersion version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRegistered() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticInstrument)) {
            return false;
        }
        StaticInstrument that = (StaticInstrument)obj;
        if (this.useDuration != that.useDuration) {
            return false;
        }
        if (Float.compare(that.range, this.range) != 0) {
            return false;
        }
        return this.sound.equals(that.sound);
    }

    public int hashCode() {
        return Objects.hash(this.sound, this.useDuration, Float.valueOf(this.range));
    }
}

