/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.item.jukebox;

import net.square.sierra.kyori.adventure.text.Component;
import net.square.sierra.packetevents.api.protocol.item.jukebox.JukeboxSong;
import net.square.sierra.packetevents.api.protocol.mapper.CopyableEntity;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTFloat;
import net.square.sierra.packetevents.api.protocol.nbt.NBTInt;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.sound.Sound;
import net.square.sierra.packetevents.api.util.adventure.AdventureSerializer;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface IJukeboxSong
extends MappedEntity,
CopyableEntity<IJukeboxSong> {
    public Sound getSound();

    public Component getDescription();

    public float getLengthInSeconds();

    public int getComparatorOutput();

    public static IJukeboxSong decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound sound = Sound.decode(compound.getTagOrThrow("sound_event"), version);
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        float length = compound.getNumberTagOrThrow("length_in_seconds").getAsFloat();
        int comparator_output = compound.getNumberTagOrThrow("comparator_output").getAsInt();
        return new JukeboxSong(data, sound, description, length, comparator_output);
    }

    public static NBT encode(IJukeboxSong jukeboxSong, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_event", Sound.encode(jukeboxSong.getSound(), version));
        compound.setTag("description", AdventureSerializer.toNbt(jukeboxSong.getDescription()));
        compound.setTag("length_in_seconds", new NBTFloat(jukeboxSong.getLengthInSeconds()));
        compound.setTag("comparator_output", new NBTInt(jukeboxSong.getComparatorOutput()));
        return compound;
    }

    public static IJukeboxSong read(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        Component description = wrapper.readComponent();
        float lengthInSeconds = wrapper.readFloat();
        int comparatorOutput = wrapper.readVarInt();
        return new JukeboxSong(null, sound, description, lengthInSeconds, comparatorOutput);
    }

    public static void write(PacketWrapper<?> wrapper, IJukeboxSong song) {
        Sound.write(wrapper, song.getSound());
        wrapper.writeComponent(song.getDescription());
        wrapper.writeFloat(song.getLengthInSeconds());
        wrapper.writeVarInt(song.getComparatorOutput());
    }
}

