/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTString;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.mappings.IRegistry;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class MappedEntitySet<T> {
    @Nullable
    private final ResourceLocation tagKey;
    @Nullable
    private final List<T> entities;

    public MappedEntitySet(ResourceLocation tagKey) {
        this(tagKey, null);
    }

    public MappedEntitySet(List<T> entities) {
        this(null, entities);
    }

    public MappedEntitySet(@Nullable ResourceLocation tagKey, @Nullable List<T> entities) {
        if (tagKey == null && entities == null) {
            throw new IllegalArgumentException("Illegal generic holder set: either tag key or holder ids have to be set");
        }
        this.tagKey = tagKey;
        this.entities = entities;
    }

    public static <Z extends MappedEntity> MappedEntitySet<Z> createEmpty() {
        return new MappedEntitySet(new ArrayList(0));
    }

    public static <Z extends MappedEntity> MappedEntitySet<Z> read(PacketWrapper<?> wrapper, BiFunction<ClientVersion, Integer, Z> getter) {
        int count = wrapper.readVarInt() - 1;
        if (count == -1) {
            return new MappedEntitySet(wrapper.readIdentifier(), null);
        }
        ArrayList<Z> entities = new ArrayList<Z>(Math.min(count, 65536));
        for (int i = 0; i < count; ++i) {
            entities.add(wrapper.readMappedEntity(getter));
        }
        return new MappedEntitySet(null, entities);
    }

    public static <Z extends MappedEntity> void write(PacketWrapper<?> wrapper, MappedEntitySet<Z> set) {
        if (set.tagKey != null) {
            wrapper.writeByte(0);
            wrapper.writeIdentifier(set.tagKey);
            return;
        }
        assert (set.entities != null);
        wrapper.writeVarInt(set.entities.size() + 1);
        for (MappedEntity entity : set.entities) {
            wrapper.writeMappedEntity(entity);
        }
    }

    public static <Z extends MappedEntity> MappedEntitySet<Z> decode(NBT nbt, ClientVersion version, IRegistry<Z> registry) {
        if (nbt instanceof NBTString) {
            String tagName = ((NBTString)nbt).getValue();
            ResourceLocation tagKey = new ResourceLocation(tagName);
            return new MappedEntitySet(tagKey);
        }
        NBTList listTag = (NBTList)nbt;
        ArrayList<Z> list = new ArrayList<Z>(listTag.size());
        for (NBT tag : listTag.getTags()) {
            ResourceLocation tagKey = new ResourceLocation(((NBTString)tag).getValue());
            list.add(registry.getByName(tagKey));
        }
        return new MappedEntitySet(list);
    }

    public static <Z extends MappedEntity> NBT encode(MappedEntitySet<Z> set, ClientVersion version) {
        if (set.tagKey != null) {
            return new NBTString(set.tagKey.toString());
        }
        assert (set.entities != null);
        NBTList<NBTString> listTag = NBTList.createStringList();
        for (MappedEntity entity : set.entities) {
            listTag.addTag(new NBTString(entity.getName().toString()));
        }
        return listTag;
    }

    public boolean isEmpty() {
        return this.entities != null && this.entities.isEmpty();
    }

    @Nullable
    public ResourceLocation getTagKey() {
        return this.tagKey;
    }

    @Nullable
    public List<T> getEntities() {
        return this.entities;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MappedEntitySet)) {
            return false;
        }
        MappedEntitySet that = (MappedEntitySet)obj;
        if (!Objects.equals(this.tagKey, that.tagKey)) {
            return false;
        }
        return Objects.equals(this.entities, that.entities);
    }

    public int hashCode() {
        return Objects.hash(this.tagKey, this.entities);
    }

    public String toString() {
        return "MappedEntitySet{tagKey=" + this.tagKey + ", entities=" + this.entities + '}';
    }
}

