/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.particle.data;

import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.protocol.color.Color;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTFloat;
import net.square.sierra.packetevents.api.protocol.particle.data.ParticleData;
import net.square.sierra.packetevents.api.protocol.particle.data.ParticleDustData;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.util.Vector3f;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public class ParticleDustColorTransitionData
extends ParticleData {
    private float scale;
    private float startRed;
    private float startGreen;
    private float startBlue;
    private float endRed;
    private float endGreen;
    private float endBlue;

    public ParticleDustColorTransitionData(float scale, float startRed, float startGreen, float startBlue, float endRed, float endGreen, float endBlue) {
        this.scale = scale;
        this.startRed = startRed;
        this.startGreen = startGreen;
        this.startBlue = startBlue;
        this.endRed = endRed;
        this.endGreen = endGreen;
        this.endBlue = endBlue;
    }

    public ParticleDustColorTransitionData(float scale, float[] startRGB, float[] endRGB) {
        this(scale, startRGB[0], startRGB[1], startRGB[2], endRGB[0], endRGB[1], endRGB[2]);
    }

    public ParticleDustColorTransitionData(float scale, Vector3f startRGB, Vector3f endRGB) {
        this(scale, startRGB.getX(), startRGB.getY(), startRGB.getZ(), endRGB.getX(), endRGB.getY(), endRGB.getZ());
    }

    public ParticleDustColorTransitionData(float scale, Color start, Color end) {
        this(scale, (float)start.red() / 255.0f, (float)start.green() / 255.0f, (float)start.blue() / 255.0f, (float)end.red() / 255.0f, (float)end.green() / 255.0f, (float)end.blue() / 255.0f);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getStartRed() {
        return this.startRed;
    }

    public void setStartRed(float startRed) {
        this.startRed = startRed;
    }

    public float getStartGreen() {
        return this.startGreen;
    }

    public void setStartGreen(float startGreen) {
        this.startGreen = startGreen;
    }

    public float getStartBlue() {
        return this.startBlue;
    }

    public void setStartBlue(float startBlue) {
        this.startBlue = startBlue;
    }

    public float getEndRed() {
        return this.endRed;
    }

    public void setEndRed(float endRed) {
        this.endRed = endRed;
    }

    public float getEndGreen() {
        return this.endGreen;
    }

    public void setEndGreen(float endGreen) {
        this.endGreen = endGreen;
    }

    public float getEndBlue() {
        return this.endBlue;
    }

    public void setEndBlue(float endBlue) {
        this.endBlue = endBlue;
    }

    public static ParticleDustColorTransitionData read(PacketWrapper<?> wrapper) {
        float startRed = wrapper.readFloat();
        float startGreen = wrapper.readFloat();
        float startBlue = wrapper.readFloat();
        float scale = 0.0f;
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_20_5)) {
            scale = wrapper.readFloat();
        }
        float endRed = wrapper.readFloat();
        float endGreen = wrapper.readFloat();
        float endBlue = wrapper.readFloat();
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            scale = wrapper.readFloat();
        }
        return new ParticleDustColorTransitionData(scale, startRed, startGreen, startBlue, endRed, endGreen, endBlue);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleDustColorTransitionData data) {
        wrapper.writeFloat(data.getStartRed());
        wrapper.writeFloat(data.getStartGreen());
        wrapper.writeFloat(data.getStartBlue());
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_20_5)) {
            wrapper.writeFloat(data.getScale());
        }
        wrapper.writeFloat(data.getEndRed());
        wrapper.writeFloat(data.getEndGreen());
        wrapper.writeFloat(data.getEndBlue());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeFloat(data.getScale());
        }
    }

    public static ParticleDustColorTransitionData decode(NBTCompound compound, ClientVersion version) {
        String fromColorKey = "from_color";
        String toColorKey = "to_color";
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            compound = compound.getCompoundTagOrThrow("value");
            fromColorKey = "fromColor";
            toColorKey = "toColor";
        }
        float[] fromColor = ParticleDustData.decodeColor(compound.getTagOrThrow(fromColorKey));
        float[] toColor = ParticleDustData.decodeColor(compound.getTagOrThrow(toColorKey));
        float scale = compound.getNumberTagOrThrow("scale").getAsFloat();
        return new ParticleDustColorTransitionData(scale, fromColor, toColor);
    }

    public static void encode(ParticleDustColorTransitionData data, ClientVersion version, NBTCompound compound) {
        String fromColorKey = "from_color";
        String toColorKey = "to_color";
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            NBTCompound innerCompound = new NBTCompound();
            compound.setTag("value", innerCompound);
            compound = innerCompound;
            fromColorKey = "fromColor";
            toColorKey = "toColor";
        }
        compound.setTag(fromColorKey, ParticleDustData.encodeColor(null, data.startRed, data.startGreen, data.startBlue));
        compound.setTag(toColorKey, ParticleDustData.encodeColor(null, data.endRed, data.endGreen, data.endBlue));
        compound.setTag("scale", new NBTFloat(data.scale));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

