/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.particle.data;

import net.square.sierra.packetevents.api.protocol.color.Color;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTByteArray;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTFloat;
import net.square.sierra.packetevents.api.protocol.nbt.NBTIntArray;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.nbt.NBTLongArray;
import net.square.sierra.packetevents.api.protocol.nbt.NBTNumber;
import net.square.sierra.packetevents.api.protocol.nbt.NBTType;
import net.square.sierra.packetevents.api.protocol.particle.data.ParticleData;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.util.Vector3f;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ParticleDustData
extends ParticleData {
    private float scale;
    private float red;
    private float green;
    private float blue;

    public ParticleDustData(float scale, float red, float green, float blue) {
        this.scale = scale;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleDustData(float scale, float[] rgb) {
        this(scale, rgb[0], rgb[1], rgb[2]);
    }

    public ParticleDustData(float scale, Vector3f rgb) {
        this(scale, rgb.getX(), rgb.getY(), rgb.getZ());
    }

    public ParticleDustData(float scale, Color color) {
        this(scale, (float)color.red() / 255.0f, (float)color.green() / 255.0f, (float)color.blue() / 255.0f);
    }

    public float getRed() {
        return this.red;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public float getGreen() {
        return this.green;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public static ParticleDustData read(PacketWrapper<?> wrapper) {
        float red = wrapper.readFloat();
        float green = wrapper.readFloat();
        float blue = wrapper.readFloat();
        float scale = wrapper.readFloat();
        return new ParticleDustData(scale, red, green, blue);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleDustData data) {
        wrapper.writeFloat(data.getRed());
        wrapper.writeFloat(data.getGreen());
        wrapper.writeFloat(data.getBlue());
        wrapper.writeFloat(data.getScale());
    }

    @ApiStatus.Internal
    public static float[] decodeColor(NBT tag) {
        if (tag instanceof NBTList) {
            NBTList colorTagList = (NBTList)tag;
            float first = ((NBTNumber)colorTagList.getTag(0)).getAsFloat();
            float second = ((NBTNumber)colorTagList.getTag(1)).getAsFloat();
            float third = ((NBTNumber)colorTagList.getTag(2)).getAsFloat();
            if (colorTagList.size() > 3) {
                float fourth = ((NBTNumber)colorTagList.getTag(3)).getAsFloat();
                return new float[]{first, second, third, fourth};
            }
            return new float[]{first, second, third};
        }
        if (tag instanceof NBTByteArray) {
            float[] fArray;
            byte[] colors = ((NBTByteArray)tag).getValue();
            if (colors.length > 3) {
                float[] fArray2 = new float[4];
                fArray2[0] = colors[0];
                fArray2[1] = colors[1];
                fArray2[2] = colors[2];
                fArray = fArray2;
                fArray2[3] = colors[3];
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = colors[0];
                fArray3[1] = colors[1];
                fArray = fArray3;
                fArray3[2] = colors[2];
            }
            return fArray;
        }
        if (tag instanceof NBTIntArray) {
            float[] fArray;
            int[] colors = ((NBTIntArray)tag).getValue();
            if (colors.length > 3) {
                float[] fArray4 = new float[4];
                fArray4[0] = colors[0];
                fArray4[1] = colors[1];
                fArray4[2] = colors[2];
                fArray = fArray4;
                fArray4[3] = colors[3];
            } else {
                float[] fArray5 = new float[3];
                fArray5[0] = colors[0];
                fArray5[1] = colors[1];
                fArray = fArray5;
                fArray5[2] = colors[2];
            }
            return fArray;
        }
        if (tag instanceof NBTLongArray) {
            float[] fArray;
            long[] colors = ((NBTLongArray)tag).getValue();
            if (colors.length > 3) {
                float[] fArray6 = new float[4];
                fArray6[0] = colors[0];
                fArray6[1] = colors[1];
                fArray6[2] = colors[2];
                fArray = fArray6;
                fArray6[3] = colors[3];
            } else {
                float[] fArray7 = new float[3];
                fArray7[0] = colors[0];
                fArray7[1] = colors[1];
                fArray = fArray7;
                fArray7[2] = colors[2];
            }
            return fArray;
        }
        throw new UnsupportedOperationException("Unsupported color nbt tag: " + tag);
    }

    @ApiStatus.Internal
    public static NBT encodeColor(@Nullable Float alpha, float red, float green, float blue) {
        NBTList<NBTFloat> nbtList = new NBTList<NBTFloat>(NBTType.FLOAT, alpha == null ? 3 : 4);
        if (alpha != null) {
            nbtList.addTag(new NBTFloat(alpha.floatValue()));
        }
        nbtList.addTag(new NBTFloat(red));
        nbtList.addTag(new NBTFloat(green));
        nbtList.addTag(new NBTFloat(blue));
        return nbtList;
    }

    public static ParticleDustData decode(NBTCompound compound, ClientVersion version) {
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            compound = compound.getCompoundTagOrThrow("value");
        }
        NBT colorNBT = compound.getTagOrNull("color");
        float[] color = ParticleDustData.decodeColor(colorNBT);
        float scale = compound.getNumberTagOrThrow("scale").getAsFloat();
        return new ParticleDustData(scale, color);
    }

    public static void encode(ParticleDustData data, ClientVersion version, NBTCompound compound) {
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            NBTCompound innerCompound = new NBTCompound();
            compound.setTag("value", innerCompound);
            compound = innerCompound;
        }
        compound.setTag("color", ParticleDustData.encodeColor(null, data.red, data.green, data.blue));
        compound.setTag("scale", new NBTFloat(data.scale));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

