/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.particle.data;

import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTInt;
import net.square.sierra.packetevents.api.protocol.particle.data.ParticleData;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public class ParticleShriekData
extends ParticleData {
    private int delay;

    public ParticleShriekData(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public static ParticleShriekData read(PacketWrapper<?> wrapper) {
        return new ParticleShriekData(wrapper.readVarInt());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleShriekData data) {
        wrapper.writeVarInt(data.getDelay());
    }

    public static ParticleShriekData decode(NBTCompound compound, ClientVersion version) {
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            compound = compound.getCompoundTagOrThrow("value");
        }
        int delay = compound.getNumberTagOrThrow("delay").getAsInt();
        return new ParticleShriekData(delay);
    }

    public static void encode(ParticleShriekData data, ClientVersion version, NBTCompound compound) {
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            NBTCompound innerCompound = new NBTCompound();
            compound.setTag("value", innerCompound);
            compound = innerCompound;
        }
        compound.setTag("delay", new NBTInt(data.delay));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

