/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.particle.data;

import java.util.Optional;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTInt;
import net.square.sierra.packetevents.api.protocol.nbt.NBTIntArray;
import net.square.sierra.packetevents.api.protocol.particle.data.ParticleData;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.world.positionsource.PositionSource;
import net.square.sierra.packetevents.api.protocol.world.positionsource.PositionSourceType;
import net.square.sierra.packetevents.api.protocol.world.positionsource.PositionSourceTypes;
import net.square.sierra.packetevents.api.protocol.world.positionsource.builtin.BlockPositionSource;
import net.square.sierra.packetevents.api.protocol.world.positionsource.builtin.EntityPositionSource;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.Vector3i;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ParticleVibrationData
extends ParticleData {
    private Vector3i startingPosition;
    private PositionSource source;
    private int ticks;

    public ParticleVibrationData(@Nullable Vector3i startingPos, Vector3i blockPosition, int ticks) {
        this(startingPos, new BlockPositionSource(blockPosition), ticks);
    }

    public ParticleVibrationData(@Nullable Vector3i startingPos, int entityId, int ticks) {
        this(startingPos, new EntityPositionSource(entityId), ticks);
    }

    public ParticleVibrationData(@Nullable Vector3i startingPos, int entityId, float entityEyeHeight, int ticks) {
        this(startingPos, new EntityPositionSource(entityId, entityEyeHeight), ticks);
    }

    public ParticleVibrationData(PositionSource source, int ticks) {
        this(null, source, ticks);
    }

    public ParticleVibrationData(@Nullable Vector3i startingPos, PositionSource source, int ticks) {
        this.startingPosition = startingPos;
        this.source = source;
        this.ticks = ticks;
    }

    public static ParticleVibrationData read(PacketWrapper<?> wrapper) {
        PositionSourceType<?> sourceType;
        Vector3i startingPos;
        Vector3i vector3i = startingPos = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_4) ? Vector3i.zero() : wrapper.readBlockPosition();
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            sourceType = wrapper.readMappedEntity(PositionSourceTypes::getById);
        } else {
            String sourceTypeName = wrapper.readString();
            sourceType = PositionSourceTypes.getByName(sourceTypeName);
            if (sourceType == null) {
                throw new IllegalArgumentException("Illegal position type: " + sourceTypeName);
            }
        }
        Object source = sourceType.read(wrapper);
        int ticks = wrapper.readVarInt();
        return new ParticleVibrationData(startingPos, (PositionSource)source, ticks);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleVibrationData data) {
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_19_4)) {
            wrapper.writeBlockPosition(data.getStartingPosition());
        }
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            wrapper.writeMappedEntity(data.getSourceType());
        } else {
            wrapper.writeIdentifier(data.getType().getName());
        }
        PositionSourceType<?> sourceType = data.getSourceType();
        sourceType.write(wrapper, data.getSource());
        wrapper.writeVarInt(data.getTicks());
    }

    public static ParticleVibrationData decode(NBTCompound compound, ClientVersion version) {
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            compound = compound.getCompoundTagOrThrow("value");
        }
        Vector3i origin = version.isNewerThanOrEquals(ClientVersion.V_1_19) ? null : new Vector3i(compound.getTagOfTypeOrThrow("origin", NBTIntArray.class).getValue());
        PositionSource destination = PositionSource.decode(compound.getCompoundTagOrThrow("destination"), version);
        int arrivalInTicks = compound.getNumberTagOrThrow("arrival_in_ticks").getAsInt();
        return new ParticleVibrationData(origin, destination, arrivalInTicks);
    }

    public static void encode(ParticleVibrationData data, ClientVersion version, NBTCompound compound) {
        Vector3i startPos;
        if (version.isOlderThan(ClientVersion.V_1_20_5)) {
            NBTCompound innerCompound = new NBTCompound();
            compound.setTag("value", innerCompound);
            compound = innerCompound;
        }
        if (version.isOlderThan(ClientVersion.V_1_19) && (startPos = data.getStartingPosition()) != null) {
            compound.setTag("origin", new NBTIntArray(new int[]{startPos.x, startPos.y, startPos.z}));
        }
        compound.setTag("destination", PositionSource.encode(data.source, version));
        compound.setTag("arrival_in_ticks", new NBTInt(data.ticks));
    }

    @ApiStatus.Obsolete
    public Vector3i getStartingPosition() {
        return this.startingPosition;
    }

    @ApiStatus.Obsolete
    public void setStartingPosition(Vector3i startingPosition) {
        this.startingPosition = startingPosition;
    }

    @Deprecated
    public PositionType getType() {
        return PositionType.byModern(this.source.getType());
    }

    public PositionSourceType<?> getSourceType() {
        return this.source.getType();
    }

    public PositionSource getSource() {
        return this.source;
    }

    public Optional<Vector3i> getBlockPosition() {
        if (this.source instanceof BlockPositionSource) {
            return Optional.of(((BlockPositionSource)this.source).getPos());
        }
        return Optional.empty();
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.source = new BlockPositionSource(blockPosition);
    }

    public Optional<Integer> getEntityId() {
        if (this.source instanceof EntityPositionSource) {
            return Optional.of(((EntityPositionSource)this.source).getEntityId());
        }
        return Optional.empty();
    }

    public void setEntityId(int entityId) {
        float offsetY = this.getEntityEyeHeight().orElse(Float.valueOf(0.0f)).floatValue();
        this.source = new EntityPositionSource(entityId, offsetY);
    }

    public Optional<Float> getEntityEyeHeight() {
        if (this.source instanceof EntityPositionSource) {
            return Optional.of(Float.valueOf(((EntityPositionSource)this.source).getOffsetY()));
        }
        return Optional.empty();
    }

    public void setEntityEyeHeight(Float offsetY) {
        this.setEntityEyeHeight(offsetY == null ? 0.0f : offsetY.floatValue());
    }

    public void setEntityEyeHeight(float offsetY) {
        int entityId = this.getEntityId().orElse(0);
        this.source = new EntityPositionSource(entityId, offsetY);
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Deprecated
    public static enum PositionType implements MappedEntity
    {
        BLOCK(PositionSourceTypes.BLOCK),
        ENTITY(PositionSourceTypes.ENTITY);

        private final PositionSourceType<?> type;

        private PositionType(PositionSourceType<?> type) {
            this.type = type;
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static PositionType byModern(@Nullable PositionSourceType<?> type) {
            if (type == null) {
                return null;
            }
            for (PositionType legacyType : PositionType.values()) {
                if (legacyType.type != type) continue;
                return legacyType;
            }
            throw new UnsupportedOperationException("Unsupported modern type: " + type.getName());
        }

        public static PositionType getById(int id) {
            ClientVersion version = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
            return PositionType.byModern(PositionSourceTypes.getById(version, id));
        }

        @Nullable
        public static PositionType getByName(String name) {
            return PositionType.getByName(new ResourceLocation(name));
        }

        @Nullable
        public static PositionType getByName(ResourceLocation name) {
            return PositionType.byModern(PositionSourceTypes.getByName(name.toString()));
        }

        @Override
        public ResourceLocation getName() {
            return this.type.getName();
        }

        @Override
        public int getId(ClientVersion version) {
            return this.type.getId(version);
        }
    }
}

