/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.world.chunk;

import java.util.Arrays;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.world.chunk.BaseChunk;
import net.square.sierra.packetevents.api.protocol.world.chunk.TileEntity;

public class Column {
    private final int x;
    private final int z;
    private final boolean fullChunk;
    private final BaseChunk[] chunks;
    private final TileEntity[] tileEntities;
    private final boolean hasHeightMaps;
    private final NBTCompound heightMaps;
    private final boolean hasBiomeData;
    private int[] biomeDataInts;
    private byte[] biomeDataBytes;

    public Column(int x, int z, boolean fullChunk, BaseChunk[] chunks, TileEntity[] tileEntities, int[] biomeData) {
        this.x = x;
        this.z = z;
        this.fullChunk = fullChunk;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.tileEntities = tileEntities != null ? tileEntities : new TileEntity[]{};
        this.hasHeightMaps = false;
        this.heightMaps = new NBTCompound();
        this.hasBiomeData = true;
        this.biomeDataInts = biomeData != null ? Arrays.copyOf(biomeData, biomeData.length) : null;
    }

    public Column(int x, int z, boolean fullChunk, BaseChunk[] chunks, TileEntity[] tileEntities) {
        this.x = x;
        this.z = z;
        this.fullChunk = fullChunk;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.tileEntities = tileEntities != null ? tileEntities : new TileEntity[]{};
        this.hasHeightMaps = false;
        this.heightMaps = new NBTCompound();
        this.hasBiomeData = false;
        this.biomeDataInts = new int[1024];
    }

    public Column(int x, int z, boolean fullChunk, BaseChunk[] chunks, TileEntity[] tileEntities, NBTCompound heightMaps) {
        this.x = x;
        this.z = z;
        this.fullChunk = fullChunk;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.tileEntities = tileEntities != null ? tileEntities : new TileEntity[]{};
        this.hasHeightMaps = true;
        this.heightMaps = heightMaps;
        this.hasBiomeData = false;
        this.biomeDataInts = new int[1024];
    }

    public Column(int x, int z, boolean fullChunk, BaseChunk[] chunks, TileEntity[] tileEntities, NBTCompound heightMaps, int[] biomeDataInts) {
        this.x = x;
        this.z = z;
        this.fullChunk = fullChunk;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.tileEntities = tileEntities != null ? tileEntities : new TileEntity[]{};
        this.hasHeightMaps = true;
        this.heightMaps = heightMaps;
        this.hasBiomeData = true;
        this.biomeDataInts = biomeDataInts != null ? Arrays.copyOf(biomeDataInts, biomeDataInts.length) : null;
    }

    public Column(int x, int z, boolean fullChunk, BaseChunk[] chunks, TileEntity[] tileEntities, NBTCompound heightMaps, byte[] biomeData) {
        this.x = x;
        this.z = z;
        this.fullChunk = fullChunk;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.tileEntities = tileEntities != null ? tileEntities : new TileEntity[]{};
        this.hasHeightMaps = true;
        this.heightMaps = heightMaps;
        this.hasBiomeData = true;
        this.biomeDataBytes = biomeData != null ? Arrays.copyOf(biomeData, biomeData.length) : null;
    }

    public Column(int chunkX, int chunkZ, boolean fullChunk, BaseChunk[] chunks, TileEntity[] tileEntities, byte[] biomeDataBytes) {
        this.x = chunkX;
        this.z = chunkZ;
        this.fullChunk = fullChunk;
        this.chunks = Arrays.copyOf(chunks, chunks.length);
        this.tileEntities = tileEntities != null ? tileEntities : new TileEntity[]{};
        this.hasHeightMaps = false;
        this.heightMaps = new NBTCompound();
        this.hasBiomeData = true;
        this.biomeDataBytes = biomeDataBytes != null ? Arrays.copyOf(biomeDataBytes, biomeDataBytes.length) : null;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isFullChunk() {
        return this.fullChunk;
    }

    public BaseChunk[] getChunks() {
        return this.chunks;
    }

    public TileEntity[] getTileEntities() {
        return this.tileEntities;
    }

    public boolean hasHeightMaps() {
        return this.hasHeightMaps;
    }

    public NBTCompound getHeightMaps() {
        return this.heightMaps;
    }

    public boolean hasBiomeData() {
        return this.hasBiomeData;
    }

    public int[] getBiomeDataInts() {
        return this.biomeDataInts;
    }

    public byte[] getBiomeDataBytes() {
        return this.biomeDataBytes;
    }
}

