/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.world.damagetype;

import java.util.Collection;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.world.damagetype.DamageEffects;
import net.square.sierra.packetevents.api.protocol.world.damagetype.DamageScaling;
import net.square.sierra.packetevents.api.protocol.world.damagetype.DamageType;
import net.square.sierra.packetevents.api.protocol.world.damagetype.DeathMessageType;
import net.square.sierra.packetevents.api.protocol.world.damagetype.StaticDamageType;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import net.square.sierra.packetevents.api.util.mappings.VersionedRegistry;
import org.jetbrains.annotations.ApiStatus;

public class DamageTypes {
    private static final VersionedRegistry<DamageType> REGISTRY = new VersionedRegistry("damage_type", "damage/damagetype_mappings");
    public static final DamageType ARROW = DamageTypes.define("arrow", "arrow", 0.1f);
    public static final DamageType BAD_RESPAWN_POINT = DamageTypes.define("bad_respawn_point", "badRespawnPoint", DamageScaling.ALWAYS, 0.1f, DamageEffects.HURT, DeathMessageType.INTENTIONAL_GAME_DESIGN);
    public static final DamageType CACTUS = DamageTypes.define("cactus", "cactus", 0.1f);
    public static final DamageType CAMPFIRE = DamageTypes.define("campfire", "inFire", 0.1f, DamageEffects.BURNING);
    public static final DamageType CRAMMING = DamageTypes.define("cramming", "cramming", 0.0f);
    public static final DamageType DRAGON_BREATH = DamageTypes.define("dragon_breath", "dragonBreath", 0.0f);
    public static final DamageType DROWN = DamageTypes.define("drown", "drown", 0.0f, DamageEffects.DROWNING);
    public static final DamageType DRY_OUT = DamageTypes.define("dry_out", "dryout", 0.1f);
    public static final DamageType EXPLOSION = DamageTypes.define("explosion", "explosion", DamageScaling.ALWAYS, 0.1f);
    public static final DamageType FALL = DamageTypes.define("fall", "fall", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.0f, DamageEffects.HURT, DeathMessageType.FALL_VARIANTS);
    public static final DamageType FALLING_ANVIL = DamageTypes.define("falling_anvil", "anvil", 0.1f);
    public static final DamageType FALLING_BLOCK = DamageTypes.define("falling_block", "fallingBlock", 0.1f);
    public static final DamageType FALLING_STALACTITE = DamageTypes.define("falling_stalactite", "fallingStalactite", 0.1f);
    public static final DamageType FELL_OUT_OF_WORLD = DamageTypes.define("out_of_world", "outOfWorld", 0.0f);
    public static final DamageType FIREBALL = DamageTypes.define("fireball", "fireball", 0.1f, DamageEffects.BURNING);
    public static final DamageType FIREWORKS = DamageTypes.define("fireworks", "fireworks", 0.1f);
    public static final DamageType FLY_INTO_WALL = DamageTypes.define("fly_into_wall", "flyIntoWall", 0.0f);
    public static final DamageType FREEZE = DamageTypes.define("freeze", "freeze", 0.0f, DamageEffects.FREEZING);
    public static final DamageType GENERIC = DamageTypes.define("generic", "generic", 0.0f);
    public static final DamageType GENERIC_KILL = DamageTypes.define("generic_kill", "genericKill", 0.0f);
    public static final DamageType HOT_FLOOR = DamageTypes.define("hot_floor", "hotFloor", 0.1f, DamageEffects.BURNING);
    public static final DamageType IN_FIRE = DamageTypes.define("in_fire", "inFire", 0.1f, DamageEffects.BURNING);
    public static final DamageType IN_WALL = DamageTypes.define("in_wall", "inWall", 0.0f);
    public static final DamageType INDIRECT_MAGIC = DamageTypes.define("indirect_magic", "indirectMagic", 0.0f);
    public static final DamageType LAVA = DamageTypes.define("lava", "lava", 0.1f, DamageEffects.BURNING);
    public static final DamageType LIGHTNING_BOLT = DamageTypes.define("lightning_bolt", "lightningBolt", 0.1f);
    public static final DamageType MAGIC = DamageTypes.define("magic", "magic", 0.0f);
    public static final DamageType MOB_ATTACK = DamageTypes.define("mob_attack", "mob", 0.1f);
    public static final DamageType MOB_ATTACK_NO_AGGRO = DamageTypes.define("mob_attack_no_aggro", "mob", 0.1f);
    public static final DamageType MOB_PROJECTILE = DamageTypes.define("mob_projectile", "mob", 0.1f);
    public static final DamageType ON_FIRE = DamageTypes.define("on_fire", "onFire", 0.0f, DamageEffects.BURNING);
    public static final DamageType OUTSIDE_BORDER = DamageTypes.define("outside_border", "outsideBorder", 0.0f);
    public static final DamageType PLAYER_ATTACK = DamageTypes.define("player_attack", "player", 0.1f);
    public static final DamageType PLAYER_EXPLOSION = DamageTypes.define("player_explosion", "explosion.player", DamageScaling.ALWAYS, 0.1f);
    public static final DamageType SONIC_BOOM = DamageTypes.define("sonic_boom", "sonic_boom", DamageScaling.ALWAYS, 0.0f);
    public static final DamageType SPIT = DamageTypes.define("spit", "mob", 0.1f);
    public static final DamageType STALAGMITE = DamageTypes.define("stalagmite", "stalagmite", 0.0f);
    public static final DamageType STARVE = DamageTypes.define("starve", "starve", 0.0f);
    public static final DamageType STING = DamageTypes.define("sting", "sting", 0.1f);
    public static final DamageType SWEET_BERRY_BUSH = DamageTypes.define("sweet_berry_bush", "sweetBerryBush", 0.1f, DamageEffects.POKING);
    public static final DamageType THORNS = DamageTypes.define("thorns", "thorns", 0.1f, DamageEffects.THORNS);
    public static final DamageType THROWN = DamageTypes.define("thrown", "thrown", 0.1f);
    public static final DamageType TRIDENT = DamageTypes.define("trident", "trident", 0.1f);
    public static final DamageType UNATTRIBUTED_FIREBALL = DamageTypes.define("unattributed_fireball", "onFire", 0.1f, DamageEffects.BURNING);
    public static final DamageType WIND_CHARGE = DamageTypes.define("wind_charge", "mob", 0.1f);
    public static final DamageType WITHER = DamageTypes.define("wither", "wither", 0.0f);
    public static final DamageType WITHER_SKULL = DamageTypes.define("wither_skull", "witherSkull", 0.1f);

    private DamageTypes() {
    }

    @ApiStatus.Internal
    public static DamageType define(String key, String messageId, float exhaustion) {
        return DamageTypes.define(key, messageId, DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, exhaustion, DamageEffects.HURT, DeathMessageType.DEFAULT);
    }

    @ApiStatus.Internal
    public static DamageType define(String key, String messageId, float exhaustion, DamageEffects damageEffects) {
        return DamageTypes.define(key, messageId, DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, exhaustion, damageEffects, DeathMessageType.DEFAULT);
    }

    @ApiStatus.Internal
    public static DamageType define(String key, String messageId, DamageScaling scaling, float exhaustion) {
        return DamageTypes.define(key, messageId, scaling, exhaustion, DamageEffects.HURT, DeathMessageType.DEFAULT);
    }

    @ApiStatus.Internal
    public static DamageType define(String key, String messageId, DamageScaling scaling, float exhaustion, DamageEffects damageEffects, DeathMessageType deathMessageType) {
        return REGISTRY.define(key, data -> new StaticDamageType((TypesBuilderData)data, messageId, scaling, exhaustion, damageEffects, deathMessageType));
    }

    public static DamageType getByName(String name) {
        return REGISTRY.getByName(name);
    }

    public static DamageType getById(ClientVersion version, int id) {
        return REGISTRY.getById(version, id);
    }

    public static VersionedRegistry<DamageType> getRegistry() {
        return REGISTRY;
    }

    public static Collection<DamageType> values() {
        return REGISTRY.getEntries();
    }

    static {
        REGISTRY.unloadMappings();
    }
}

