/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.world.dimension;

import java.util.OptionalLong;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.protocol.mapper.CopyableEntity;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTByte;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTDouble;
import net.square.sierra.packetevents.api.protocol.nbt.NBTFloat;
import net.square.sierra.packetevents.api.protocol.nbt.NBTInt;
import net.square.sierra.packetevents.api.protocol.nbt.NBTLong;
import net.square.sierra.packetevents.api.protocol.nbt.NBTString;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.world.dimension.DimensionTypeRef;
import net.square.sierra.packetevents.api.protocol.world.dimension.StaticDimensionType;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.Nullable;

public interface DimensionType
extends MappedEntity,
CopyableEntity<DimensionType> {
    public OptionalLong getFixedTime();

    public boolean hasSkyLight();

    public boolean hasCeiling();

    public boolean isUltraWarm();

    public boolean isNatural();

    public double getCoordinateScale();

    default public boolean isShrunk() {
        return this.getCoordinateScale() > 1.0;
    }

    public boolean isBedWorking();

    public boolean isRespawnAnchorWorking();

    default public int getMinY() {
        return this.getMinY(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public int getMinY(ClientVersion var1);

    default public int getHeight() {
        return this.getHeight(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public int getHeight(ClientVersion var1);

    default public int getLogicalHeight() {
        return this.getLogicalHeight(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public int getLogicalHeight(ClientVersion var1);

    public String getInfiniburnTag();

    public ResourceLocation getEffectsLocation();

    public float getAmbientLight();

    public boolean isPiglinSafe();

    public boolean hasRaids();

    public NBT getMonsterSpawnLightLevel();

    public int getMonsterSpawnBlockLightLimit();

    default public DimensionTypeRef asRef(ClientVersion version) {
        return new DimensionTypeRef.DirectRef(this, version);
    }

    public static DimensionType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        double coordinateScale;
        NBTCompound compound = (NBTCompound)nbt;
        OptionalLong fixedTime = !compound.getTags().containsKey("fixed_time") ? OptionalLong.empty() : OptionalLong.of(compound.getNumberTagOrThrow("fixed_time").getAsLong());
        boolean hasSkylight = compound.getBoolean("has_skylight");
        boolean hasCeiling = compound.getBoolean("has_ceiling");
        boolean ultrawarm = compound.getBoolean("ultrawarm");
        boolean natural = compound.getBoolean("natural");
        boolean bedWorking = compound.getBoolean("bed_works");
        boolean respawnAnchorWorking = compound.getBoolean("respawn_anchor_works");
        int logicalHeight = compound.getNumberTagOrThrow("logical_height").getAsInt();
        String infiniburnTag = compound.getStringTagValueOrThrow("infiniburn");
        float ambientLight = compound.getNumberTagOrThrow("ambient_light").getAsFloat();
        boolean piglinSafe = compound.getBoolean("piglin_safe");
        boolean hasRaids = compound.getBoolean("has_raids");
        int minY = 0;
        int height = 256;
        ResourceLocation effectsLocation = null;
        NBT monsterSpawnLightLevel = null;
        int monsterSpawnBlockLightLimit = 0;
        if (version.isNewerThanOrEquals(ClientVersion.V_1_16_2)) {
            coordinateScale = compound.getNumberTagOrThrow("coordinate_scale").getAsDouble();
            effectsLocation = new ResourceLocation(compound.getStringTagValueOrThrow("effects"));
            if (version.isNewerThanOrEquals(ClientVersion.V_1_17)) {
                minY = compound.getNumberTagOrThrow("min_y").getAsInt();
                height = compound.getNumberTagOrThrow("height").getAsInt();
                if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
                    monsterSpawnLightLevel = compound.getTagOrThrow("monster_spawn_light_level");
                    monsterSpawnBlockLightLimit = compound.getNumberTagOrThrow("monster_spawn_block_light_limit").getAsInt();
                }
            }
        } else {
            coordinateScale = compound.getBoolean("shrunk") ? 8.0 : 1.0;
        }
        return new StaticDimensionType(data, fixedTime, hasSkylight, hasCeiling, ultrawarm, natural, coordinateScale, bedWorking, respawnAnchorWorking, minY, height, logicalHeight, infiniburnTag, effectsLocation, ambientLight, piglinSafe, hasRaids, monsterSpawnLightLevel, monsterSpawnBlockLightLimit);
    }

    public static NBT encode(DimensionType dimensionType, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        dimensionType.getFixedTime().ifPresent(fixedTime -> compound.setTag("fixed_time", new NBTLong(fixedTime)));
        compound.setTag("has_skylight", new NBTByte(dimensionType.hasSkyLight()));
        compound.setTag("has_ceiling", new NBTByte(dimensionType.hasCeiling()));
        compound.setTag("ultrawarm", new NBTByte(dimensionType.isUltraWarm()));
        compound.setTag("natural", new NBTByte(dimensionType.isNatural()));
        compound.setTag("bed_works", new NBTByte(dimensionType.isBedWorking()));
        compound.setTag("respawn_anchor_works", new NBTByte(dimensionType.isRespawnAnchorWorking()));
        compound.setTag("logical_height", new NBTInt(dimensionType.getLogicalHeight(version)));
        compound.setTag("infiniburn", new NBTString(dimensionType.getInfiniburnTag()));
        compound.setTag("ambient_light", new NBTFloat(dimensionType.getAmbientLight()));
        compound.setTag("piglin_safe", new NBTByte(dimensionType.isPiglinSafe()));
        compound.setTag("has_raids", new NBTByte(dimensionType.hasRaids()));
        if (version.isNewerThanOrEquals(ClientVersion.V_1_16_2)) {
            compound.setTag("coordinate_scale", new NBTDouble(dimensionType.getCoordinateScale()));
            compound.setTag("effects", new NBTString(dimensionType.getEffectsLocation().toString()));
            if (version.isNewerThanOrEquals(ClientVersion.V_1_17)) {
                compound.setTag("min_y", new NBTInt(dimensionType.getMinY(version)));
                compound.setTag("height", new NBTInt(dimensionType.getHeight(version)));
                if (version.isNewerThanOrEquals(ClientVersion.V_1_19)) {
                    compound.setTag("monster_spawn_light_level", dimensionType.getMonsterSpawnLightLevel());
                    compound.setTag("monster_spawn_block_light_limit", new NBTInt(dimensionType.getMonsterSpawnBlockLightLimit()));
                }
            }
        } else {
            compound.setTag("shrunk", new NBTByte(dimensionType.isShrunk()));
        }
        return compound;
    }
}

