/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.protocol.world.positionsource;

import java.util.HashMap;
import java.util.Map;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.world.positionsource.PositionSource;
import net.square.sierra.packetevents.api.protocol.world.positionsource.PositionSourceType;
import net.square.sierra.packetevents.api.protocol.world.positionsource.builtin.BlockPositionSource;
import net.square.sierra.packetevents.api.protocol.world.positionsource.builtin.EntityPositionSource;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.mappings.MappingHelper;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilder;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PositionSourceTypes {
    private static final Map<String, PositionSourceType<?>> POS_SOURCE_MAP = new HashMap();
    private static final Map<Byte, Map<Integer, PositionSourceType<?>>> POS_SOURCE_ID_MAP = new HashMap();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("world/world_position_source_mappings");
    public static final PositionSourceType<BlockPositionSource> BLOCK = PositionSourceTypes.define("block", BlockPositionSource::read, BlockPositionSource::write, BlockPositionSource::decodeSource, BlockPositionSource::encodeSource);
    public static final PositionSourceType<EntityPositionSource> ENTITY = PositionSourceTypes.define("entity", EntityPositionSource::read, EntityPositionSource::write, EntityPositionSource::decodeSource, EntityPositionSource::encodeSource);

    @ApiStatus.Internal
    public static <T extends PositionSource> PositionSourceType<T> define(String key, final PacketWrapper.Reader<T> reader, final PacketWrapper.Writer<T> writer, final Decoder<T> decoder, final Encoder<T> encoder) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        PositionSourceType sourceType = new PositionSourceType<T>(){

            @Override
            public T read(PacketWrapper<?> wrapper) {
                return (PositionSource)reader.apply(wrapper);
            }

            @Override
            public void write(PacketWrapper<?> wrapper, T source) {
                writer.accept(wrapper, source);
            }

            @Override
            public T decode(NBTCompound compound, ClientVersion version) {
                return (PositionSource)decoder.decode(compound, version);
            }

            @Override
            public void encode(T source, ClientVersion version, NBTCompound compound) {
                encoder.encode(source, version, compound);
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PositionSourceType) {
                    return this.getName().equals(((PositionSourceType)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, POS_SOURCE_MAP, POS_SOURCE_ID_MAP, sourceType);
        return sourceType;
    }

    @Nullable
    public static PositionSourceType<?> getByName(String name) {
        return POS_SOURCE_MAP.get(name);
    }

    public static PositionSourceType<?> getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, PositionSourceType<?>> idMap = POS_SOURCE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }

    @FunctionalInterface
    public static interface Decoder<T> {
        public T decode(NBTCompound var1, ClientVersion var2);
    }

    @FunctionalInterface
    public static interface Encoder<T> {
        public void encode(T var1, ClientVersion var2, NBTCompound var3);
    }
}

