/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.util;

import java.util.Collections;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.protocol.player.Equipment;
import net.square.sierra.packetevents.api.protocol.world.chunk.LightData;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerChunkData;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerDestroyEntities;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerEntityEquipment;
import net.square.sierra.packetevents.api.wrapper.play.server.WrapperPlayServerUpdateLight;

public class PacketTransformationUtil {
    public static PacketWrapper<?>[] transform(PacketWrapper<?> wrapper) {
        if (wrapper instanceof WrapperPlayServerDestroyEntities) {
            WrapperPlayServerDestroyEntities destroyEntities = (WrapperPlayServerDestroyEntities)wrapper;
            int len = destroyEntities.getEntityIds().length;
            if (wrapper.getServerVersion() == ServerVersion.V_1_17 && len > 1) {
                PacketWrapper[] output = new PacketWrapper[len];
                for (int i = 0; i < len; ++i) {
                    int entityId = destroyEntities.getEntityIds()[i];
                    output[i] = new WrapperPlayServerDestroyEntities(entityId);
                }
                return output;
            }
        } else if (wrapper instanceof WrapperPlayServerEntityEquipment) {
            WrapperPlayServerEntityEquipment entityEquipment = (WrapperPlayServerEntityEquipment)wrapper;
            int len = entityEquipment.getEquipment().size();
            if (entityEquipment.getServerVersion().isOlderThan(ServerVersion.V_1_16) && len > 1) {
                PacketWrapper[] output = new PacketWrapper[len];
                for (int i = 0; i < len; ++i) {
                    Equipment equipment = entityEquipment.getEquipment().get(i);
                    output[i] = new WrapperPlayServerEntityEquipment(entityEquipment.getEntityId(), Collections.singletonList(equipment));
                }
                return output;
            }
        } else if (wrapper instanceof WrapperPlayServerChunkData) {
            WrapperPlayServerChunkData chunkData = (WrapperPlayServerChunkData)wrapper;
            LightData lightData = chunkData.getLightData();
            if (chunkData.getServerVersion().isOlderThan(ServerVersion.V_1_18) && lightData != null) {
                PacketWrapper[] output = new PacketWrapper[]{new WrapperPlayServerUpdateLight(chunkData.getColumn().getX(), chunkData.getColumn().getZ(), lightData), chunkData};
                return output;
            }
        }
        return new PacketWrapper[]{wrapper};
    }
}

