/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.util.mappings;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.square.sierra.packetevents.api.PacketEvents;
import net.square.sierra.packetevents.api.protocol.chat.ChatType;
import net.square.sierra.packetevents.api.protocol.chat.ChatTypes;
import net.square.sierra.packetevents.api.protocol.entity.wolfvariant.WolfVariant;
import net.square.sierra.packetevents.api.protocol.entity.wolfvariant.WolfVariants;
import net.square.sierra.packetevents.api.protocol.item.banner.BannerPattern;
import net.square.sierra.packetevents.api.protocol.item.banner.BannerPatterns;
import net.square.sierra.packetevents.api.protocol.item.enchantment.type.EnchantmentType;
import net.square.sierra.packetevents.api.protocol.item.enchantment.type.EnchantmentTypes;
import net.square.sierra.packetevents.api.protocol.item.jukebox.IJukeboxSong;
import net.square.sierra.packetevents.api.protocol.item.jukebox.JukeboxSongs;
import net.square.sierra.packetevents.api.protocol.item.trimmaterial.TrimMaterial;
import net.square.sierra.packetevents.api.protocol.item.trimmaterial.TrimMaterials;
import net.square.sierra.packetevents.api.protocol.item.trimpattern.TrimPattern;
import net.square.sierra.packetevents.api.protocol.item.trimpattern.TrimPatterns;
import net.square.sierra.packetevents.api.protocol.mapper.CopyableEntity;
import net.square.sierra.packetevents.api.protocol.mapper.MappedEntity;
import net.square.sierra.packetevents.api.protocol.nbt.NBT;
import net.square.sierra.packetevents.api.protocol.nbt.NBTCompound;
import net.square.sierra.packetevents.api.protocol.nbt.NBTList;
import net.square.sierra.packetevents.api.protocol.player.ClientVersion;
import net.square.sierra.packetevents.api.protocol.player.User;
import net.square.sierra.packetevents.api.protocol.world.biome.Biome;
import net.square.sierra.packetevents.api.protocol.world.biome.Biomes;
import net.square.sierra.packetevents.api.protocol.world.damagetype.DamageType;
import net.square.sierra.packetevents.api.protocol.world.damagetype.DamageTypes;
import net.square.sierra.packetevents.api.protocol.world.dimension.DimensionType;
import net.square.sierra.packetevents.api.protocol.world.dimension.DimensionTypes;
import net.square.sierra.packetevents.api.protocol.world.painting.PaintingVariant;
import net.square.sierra.packetevents.api.protocol.world.painting.PaintingVariants;
import net.square.sierra.packetevents.api.resources.ResourceLocation;
import net.square.sierra.packetevents.api.util.mappings.IRegistry;
import net.square.sierra.packetevents.api.util.mappings.SimpleRegistry;
import net.square.sierra.packetevents.api.util.mappings.SimpleTypesBuilderData;
import net.square.sierra.packetevents.api.util.mappings.TypesBuilderData;
import net.square.sierra.packetevents.api.wrapper.configuration.server.WrapperConfigServerRegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SynchronizedRegistriesHandler {
    private static final boolean FORCE_PER_USER_REGISTRIES = Boolean.getBoolean("packetevents.force-per-user-registries");
    private static final Map<ResourceLocation, RegistryEntry<?>> REGISTRY_KEYS = Stream.of(new RegistryEntry<Biome>(Biomes.getRegistry(), Biome::decode), new RegistryEntry<ChatType>(ChatTypes.getRegistry(), ChatType::decode), new RegistryEntry<TrimPattern>(TrimPatterns.getRegistry(), TrimPattern::decode), new RegistryEntry<TrimMaterial>(TrimMaterials.getRegistry(), TrimMaterial::decode), new RegistryEntry<WolfVariant>(WolfVariants.getRegistry(), WolfVariant::decode), new RegistryEntry<PaintingVariant>(PaintingVariants.getRegistry(), PaintingVariant::decode), new RegistryEntry<DimensionType>(DimensionTypes.getRegistry(), DimensionType::decode), new RegistryEntry<DamageType>(DamageTypes.getRegistry(), DamageType::decode), new RegistryEntry<BannerPattern>(BannerPatterns.getRegistry(), BannerPattern::decode), new RegistryEntry<EnchantmentType>(EnchantmentTypes.getRegistry(), EnchantmentType::decode), new RegistryEntry<IJukeboxSong>(JukeboxSongs.getRegistry(), IJukeboxSong::decode)).collect(Collectors.toMap(RegistryEntry::getRegistryKey, Function.identity()));

    private SynchronizedRegistriesHandler() {
    }

    @Nullable
    public static RegistryEntry<?> getRegistryEntry(ResourceLocation registryKey) {
        return REGISTRY_KEYS.get(registryKey);
    }

    public static void handleRegistry(User user, ClientVersion version, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, version);
        SynchronizedRegistriesHandler.handleRegistry(user, version, registryName, elements, cacheKey);
    }

    public static void handleRegistry(User user, ClientVersion version, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements, Object cacheKey) {
        RegistryEntry<?> registryData = REGISTRY_KEYS.get(registryName);
        if (registryData == null) {
            return;
        }
        SimpleRegistry<?> syncedRegistry = FORCE_PER_USER_REGISTRIES || cacheKey == null ? registryData.createFromElements(elements, version) : registryData.computeSyncedRegistry(cacheKey, () -> registryData.createFromElements(elements, version));
        user.putRegistry(syncedRegistry);
    }

    public static void handleLegacyRegistries(User user, ClientVersion version, NBTCompound registryData) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, version);
        for (NBT tag : registryData.getTags().values()) {
            NBTCompound compound = (NBTCompound)tag;
            ResourceLocation registryName = new ResourceLocation(compound.getStringTagValueOrThrow("type"));
            NBTList<NBTCompound> nbtElements = compound.getCompoundListTagOrNull("value");
            if (nbtElements == null) continue;
            SynchronizedRegistriesHandler.handleRegistry(user, version, registryName, WrapperConfigServerRegistryData.RegistryElement.convertNbt(nbtElements), cacheKey);
        }
    }

    @ApiStatus.Internal
    public static final class RegistryEntry<T extends MappedEntity & CopyableEntity<T>> {
        private final IRegistry<T> baseRegistry;
        private final NbtEntryDecoder<T> decoder;
        private final Map<Object, SimpleRegistry<T>> syncedRegistries = new ConcurrentHashMap<Object, SimpleRegistry<T>>(2);

        public RegistryEntry(IRegistry<T> baseRegistry, NbtEntryDecoder<T> decoder) {
            this.baseRegistry = baseRegistry;
            this.decoder = decoder;
        }

        @Nullable
        public SimpleRegistry<T> getSyncedRegistry(Object key) {
            return this.syncedRegistries.get(key);
        }

        public SimpleRegistry<T> computeSyncedRegistry(Object key, Supplier<SimpleRegistry<?>> registry) {
            return this.syncedRegistries.computeIfAbsent(key, $ -> (SimpleRegistry)registry.get());
        }

        private void handleElement(SimpleRegistry<T> registry, WrapperConfigServerRegistryData.RegistryElement element, int id, ClientVersion version) {
            MappedEntity value;
            Object copiedBaseEntry;
            ResourceLocation elementName = element.getId();
            T baseEntry = this.baseRegistry.getByName(elementName);
            SimpleTypesBuilderData data = new SimpleTypesBuilderData(elementName, id);
            Object z = copiedBaseEntry = baseEntry == null ? null : (Object)((CopyableEntity)baseEntry).copy(data);
            if (element.getData() != null && !(value = (MappedEntity)this.decoder.decode(element.getData(), version, data)).equals(copiedBaseEntry)) {
                registry.define(elementName, id, value);
                return;
            }
            if (copiedBaseEntry != null) {
                registry.define(elementName, id, copiedBaseEntry);
                return;
            }
            PacketEvents.getAPI().getLogger().warning("Unknown registry entry " + elementName + " for " + this.getRegistryKey());
        }

        public SimpleRegistry<T> createFromElements(List<WrapperConfigServerRegistryData.RegistryElement> elements, ClientVersion version) {
            SimpleRegistry registry = new SimpleRegistry(this.getRegistryKey());
            for (int id = 0; id < elements.size(); ++id) {
                WrapperConfigServerRegistryData.RegistryElement element = elements.get(id);
                this.handleElement(registry, element, id, version);
            }
            return registry;
        }

        public ResourceLocation getRegistryKey() {
            return this.baseRegistry.getRegistryKey();
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface NbtEntryDecoder<T> {
        public T decode(NBT var1, ClientVersion var2, @Nullable TypesBuilderData var3);
    }
}

