/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.wrapper.play.client;

import java.util.ArrayList;
import java.util.List;
import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayClientEditBook
extends PacketWrapper<WrapperPlayClientEditBook> {
    public static final int MAX_BYTES_PER_CHAR = 4;
    private static final int TITLE_MAX_CHARS = 128;
    private static final int PAGE_MAX_CHARS = 8192;
    private static final int AVERAGE_PAGES = 8;
    private int slot;
    private List<String> pages;
    @Nullable
    private String title;

    public WrapperPlayClientEditBook(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientEditBook(int slot, List<String> pages, @Nullable String title) {
        super(PacketType.Play.Client.EDIT_BOOK);
        this.slot = slot;
        this.pages = pages;
        this.title = title;
    }

    @Override
    public void read() {
        this.slot = this.readVarInt();
        this.pages = new ArrayList<String>(8);
        int pagesSize = this.readVarInt();
        for (int i = 0; i < pagesSize; ++i) {
            this.pages.add(this.readString(8192));
        }
        this.title = (String)this.readOptional(reader -> reader.readString(128));
    }

    @Override
    public void write() {
        this.writeVarInt(this.slot);
        this.writeVarInt(this.pages.size());
        for (String page : this.pages) {
            this.writeString(page, 8192);
        }
        this.writeOptional(this.title, (writer, innerTitle) -> writer.writeString((String)innerTitle, 128));
    }

    @Override
    public void copy(WrapperPlayClientEditBook wrapper) {
        this.slot = wrapper.slot;
        this.pages = wrapper.pages;
        this.title = wrapper.title;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public void setPages(List<String> pages) {
        this.pages = pages;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }
}

