/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.wrapper.play.client;

import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.protocol.player.HumanoidArm;
import net.square.sierra.packetevents.api.protocol.player.SkinSection;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayClientSettings
extends PacketWrapper<WrapperPlayClientSettings> {
    private String locale;
    private int viewDistance;
    private ChatVisibility visibility;
    private boolean chatColorable;
    private byte visibleSkinSectionMask;
    private HumanoidArm hand;
    private boolean textFilteringEnabled;
    private boolean allowServerListings;
    private byte ignoredDifficulty;

    public WrapperPlayClientSettings(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientSettings(String locale, int viewDistance, ChatVisibility visibility, boolean chatColorable, byte visibleSkinSectionMask, HumanoidArm hand, boolean textFilteringEnabled, boolean allowServerListings) {
        super(PacketType.Play.Client.CLIENT_SETTINGS);
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.visibility = visibility;
        this.chatColorable = chatColorable;
        this.visibleSkinSectionMask = visibleSkinSectionMask;
        this.hand = hand;
        this.textFilteringEnabled = textFilteringEnabled;
        this.allowServerListings = allowServerListings;
    }

    @Override
    public void read() {
        int localeLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_12) ? 16 : 7;
        this.locale = this.readString(localeLength);
        this.viewDistance = this.readByte();
        int visibilityIndex = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? this.readVarInt() : (int)this.readByte();
        this.visibility = ChatVisibility.VALUES[visibilityIndex];
        this.chatColorable = this.readBoolean();
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.ignoredDifficulty = this.readByte();
            boolean showCape = this.readBoolean();
            if (showCape) {
                this.visibleSkinSectionMask = SkinSection.CAPE.getMask();
            }
        } else {
            this.visibleSkinSectionMask = (byte)this.readUnsignedByte();
        }
        this.hand = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? HumanoidArm.VALUES[this.readVarInt()] : HumanoidArm.RIGHT;
        this.textFilteringEnabled = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readBoolean() : false;
        this.allowServerListings = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18) ? this.readBoolean() : true;
    }

    @Override
    public void write() {
        int localeLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_12) ? 16 : 7;
        this.writeString(this.locale, localeLength);
        this.writeByte(this.viewDistance);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.writeVarInt(this.visibility.ordinal());
        } else {
            this.writeByte(this.visibility.ordinal());
        }
        this.writeBoolean(this.chatColorable);
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeByte(this.ignoredDifficulty);
            boolean showCape = SkinSection.CAPE.isSet(this.visibleSkinSectionMask);
            this.writeBoolean(showCape);
        } else {
            this.writeByte(this.visibleSkinSectionMask);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.writeVarInt(this.hand.ordinal());
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeBoolean(this.textFilteringEnabled);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.writeBoolean(this.allowServerListings);
        }
    }

    @Override
    public void copy(WrapperPlayClientSettings wrapper) {
        this.locale = wrapper.locale;
        this.viewDistance = wrapper.viewDistance;
        this.visibility = wrapper.visibility;
        this.chatColorable = wrapper.chatColorable;
        this.visibleSkinSectionMask = wrapper.visibleSkinSectionMask;
        this.hand = wrapper.hand;
        this.textFilteringEnabled = wrapper.textFilteringEnabled;
        this.allowServerListings = wrapper.allowServerListings;
        this.ignoredDifficulty = wrapper.ignoredDifficulty;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public ChatVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(ChatVisibility visibility) {
        this.visibility = visibility;
    }

    public boolean isChatColorable() {
        return this.chatColorable;
    }

    public void setChatColorable(boolean chatColorable) {
        this.chatColorable = chatColorable;
    }

    public byte getVisibleSkinSectionMask() {
        return this.visibleSkinSectionMask;
    }

    public void setVisibleSkinSectionMask(byte visibleSkinSectionMask) {
        this.visibleSkinSectionMask = visibleSkinSectionMask;
    }

    public SkinSection getVisibleSkinSection() {
        return new SkinSection(this.getVisibleSkinSectionMask());
    }

    public void setVisibleSkinSections(SkinSection visibleSkinSection) {
        this.visibleSkinSectionMask = visibleSkinSection.getMask();
    }

    public boolean isSkinSectionVisible(SkinSection section) {
        return section.isSet(this.visibleSkinSectionMask);
    }

    public void setSkinSectionVisible(SkinSection section, boolean visible) {
        this.visibleSkinSectionMask = section.set(this.visibleSkinSectionMask, visible);
    }

    public HumanoidArm getMainHand() {
        return this.hand;
    }

    public void setMainHand(HumanoidArm hand) {
        this.hand = hand;
    }

    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public void setTextFilteringEnabled(boolean textFilteringEnabled) {
        this.textFilteringEnabled = textFilteringEnabled;
    }

    public boolean isServerListingAllowed() {
        return this.allowServerListings;
    }

    public void setServerListingAllowed(boolean allowServerListings) {
        this.allowServerListings = allowServerListings;
    }

    public static enum ChatVisibility {
        FULL,
        SYSTEM,
        HIDDEN;

        public static final ChatVisibility[] VALUES;

        static {
            VALUES = ChatVisibility.values();
        }
    }
}

