/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.wrapper.play.client;

import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.manager.server.ServerVersion;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.util.Vector3i;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayClientUpdateSign
extends PacketWrapper<WrapperPlayClientUpdateSign> {
    private Vector3i blockPosition;
    private String[] textLines;
    private boolean isFrontText;

    public WrapperPlayClientUpdateSign(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientUpdateSign(Vector3i blockPosition, String[] textLines, boolean isFrontText) {
        super(PacketType.Play.Client.UPDATE_SIGN);
        this.blockPosition = blockPosition;
        this.textLines = textLines;
        this.isFrontText = isFrontText;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.blockPosition = new Vector3i(this.readLong());
        } else {
            int x = this.readInt();
            short y = this.readShort();
            int z = this.readInt();
            this.blockPosition = new Vector3i(x, y, z);
        }
        this.isFrontText = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20) ? this.readBoolean() : true;
        this.textLines = new String[4];
        for (int i = 0; i < 4; ++i) {
            this.textLines[i] = this.readString(384);
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            long positionVector = this.blockPosition.getSerializedPosition();
            this.writeLong(positionVector);
        } else {
            this.writeInt(this.blockPosition.x);
            this.writeShort(this.blockPosition.y);
            this.writeInt(this.blockPosition.z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20)) {
            this.writeBoolean(this.isFrontText);
        }
        for (int i = 0; i < 4; ++i) {
            this.writeString(this.textLines[i]);
        }
    }

    @Override
    public void copy(WrapperPlayClientUpdateSign wrapper) {
        this.blockPosition = wrapper.blockPosition;
        this.isFrontText = wrapper.isFrontText;
        this.textLines = wrapper.textLines;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setTextLines(String[] textLines) {
        this.textLines = textLines;
    }

    public boolean isFrontText() {
        return this.isFrontText;
    }

    public void setFrontText(boolean frontText) {
        this.isFrontText = frontText;
    }
}

