/*
 * Decompiled with CFR 0.152.
 */
package net.square.sierra.packetevents.api.wrapper.play.client;

import net.square.sierra.packetevents.api.event.PacketReceiveEvent;
import net.square.sierra.packetevents.api.protocol.packettype.PacketType;
import net.square.sierra.packetevents.api.util.Vector3d;
import net.square.sierra.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayClientVehicleMove
extends PacketWrapper<WrapperPlayClientVehicleMove> {
    private Vector3d position;
    private float yaw;
    private float pitch;

    public WrapperPlayClientVehicleMove(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientVehicleMove(Vector3d position, float yaw, float pitch) {
        super(PacketType.Play.Client.VEHICLE_MOVE);
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    public void read() {
        double x = this.readDouble();
        double y = this.readDouble();
        double z = this.readDouble();
        this.position = new Vector3d(x, y, z);
        this.yaw = this.readFloat();
        this.pitch = this.readFloat();
    }

    @Override
    public void write() {
        this.writeDouble(this.position.x);
        this.writeDouble(this.position.y);
        this.writeDouble(this.position.z);
        this.writeFloat(this.yaw);
        this.writeFloat(this.pitch);
    }

    @Override
    public void copy(WrapperPlayClientVehicleMove wrapper) {
        this.position = wrapper.position;
        this.yaw = wrapper.yaw;
        this.pitch = wrapper.pitch;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }
}

