/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Painting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.content.BetsyRossBlockEntities;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.content.BetsyRossItems;
import rbasamoyai.betsyross.flags.flag_block.DrapedFlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntityRenderer;
import rbasamoyai.betsyross.flags.standards.ArmorBannerRenderer;
import rbasamoyai.betsyross.flags.standards.BannerStandardRenderer;
import rbasamoyai.betsyross.flags.standards.FlagStandardRenderer;
import rbasamoyai.betsyross.platform.BetsyRossClientServices;

public class BetsyRossClient {
    private static BlockEntityWithoutLevelRenderer FLAG_STANDARD_RENDERER;
    private static BlockEntityWithoutLevelRenderer BANNER_STANDARD_RENDERER;
    private static BlockEntityWithoutLevelRenderer ARMOR_BANNER_RENDERER;
    private static final Set<ModelLayerLocation> ALL_LAYERS;
    public static final ModelLayerLocation ITEM_FLAGPOLE;
    public static final ModelLayerLocation ITEM_BANNER;
    public static final ModelLayerLocation ARMOR_FLAGPOLE;
    public static final ResourceLocation SPECIAL_ARMOR_BANNER_MODEL;
    public static final ResourceLocation SPECIAL_BANNER_STANDARD_MODEL;
    public static final ResourceLocation SPECIAL_BANNER_STANDARD_RAISED_MODEL;
    public static final ResourceLocation SPECIAL_FLAG_STANDARD_MODEL;

    public static BlockEntityWithoutLevelRenderer getFlagStandardRenderer() {
        if (FLAG_STANDARD_RENDERER == null) {
            Minecraft mc = Minecraft.getInstance();
            FLAG_STANDARD_RENDERER = new FlagStandardRenderer(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
        }
        return FLAG_STANDARD_RENDERER;
    }

    public static BlockEntityWithoutLevelRenderer getBannerStandardRenderer() {
        if (BANNER_STANDARD_RENDERER == null) {
            Minecraft mc = Minecraft.getInstance();
            BANNER_STANDARD_RENDERER = new BannerStandardRenderer(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
        }
        return BANNER_STANDARD_RENDERER;
    }

    public static BlockEntityWithoutLevelRenderer getArmorBannerRenderer() {
        if (ARMOR_BANNER_RENDERER == null) {
            Minecraft mc = Minecraft.getInstance();
            ARMOR_BANNER_RENDERER = new ArmorBannerRenderer(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
        }
        return ARMOR_BANNER_RENDERER;
    }

    private static ModelLayerLocation registerLayer(String id) {
        ModelLayerLocation loc = new ModelLayerLocation(BetsyRoss.path(id), "main");
        if (!ALL_LAYERS.add(loc)) {
            throw new IllegalStateException("Duplicate registration for " + String.valueOf(loc));
        }
        return loc;
    }

    public static void init(BiConsumer<Block, RenderType> layerRegistration) {
        BetsyRossClientServices.CLIENT_INDEX_PLATFORM.registerItemProperty(BetsyRossItems.BANNER_STANDARD.get(), BetsyRoss.path("raised"), (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        layerRegistration.accept(BetsyRossBlocks.EMBROIDERY_TABLE_BLOCK.get(), RenderType.cutout());
    }

    public static void registerModels(Consumer<ResourceLocation> cons) {
        cons.accept(SPECIAL_ARMOR_BANNER_MODEL);
        cons.accept(SPECIAL_BANNER_STANDARD_MODEL);
        cons.accept(SPECIAL_BANNER_STANDARD_RAISED_MODEL);
        cons.accept(SPECIAL_FLAG_STANDARD_MODEL);
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRenderers.register(BetsyRossBlockEntities.FLAG_BLOCK_ENTITY.get(), FlagBlockEntityRenderer::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> cons) {
        cons.accept(ITEM_FLAGPOLE, FlagStandardRenderer::defineFlagpole);
        cons.accept(ITEM_BANNER, BannerStandardRenderer::defineBannerBar);
        cons.accept(ARMOR_FLAGPOLE, ArmorBannerRenderer::defineArmorFlagpole);
    }

    public static boolean renderCustomItem(BlockEntityWithoutLevelRenderer original, ItemStack stack, ItemDisplayContext transform, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        if (stack.is((Item)BetsyRossItems.FLAG_STANDARD.get()) && original != BetsyRossClient.getFlagStandardRenderer()) {
            BetsyRossClient.getFlagStandardRenderer().renderByItem(stack, transform, poseStack, buffers, light, overlay);
            return true;
        }
        if (stack.is((Item)BetsyRossItems.BANNER_STANDARD.get()) && original != BetsyRossClient.getBannerStandardRenderer()) {
            BetsyRossClient.getBannerStandardRenderer().renderByItem(stack, transform, poseStack, buffers, light, overlay);
            return true;
        }
        if (stack.is((Item)BetsyRossItems.ARMOR_BANNER.get()) && original != BetsyRossClient.getArmorBannerRenderer()) {
            BetsyRossClient.getArmorBannerRenderer().renderByItem(stack, transform, poseStack, buffers, light, overlay);
            return true;
        }
        return false;
    }

    public static FlagRenderInfo getFlagRenderInfo(ResourceLocation location) {
        Optional paintingOp = ClientPaintingManager.getPainting((ResourceLocation)location);
        if (paintingOp.isPresent()) {
            Painting painting = (Painting)paintingOp.get();
            return new FlagRenderInfo(location, painting.width(), painting.height());
        }
        return new FlagRenderInfo(BetsyRoss.DEFAULT_FLAG, 1, 1);
    }

    public static AABB getFlagBlockEntityBox(FlagBlockEntity flag) {
        BlockState state = flag.getBlockState();
        BlockPos pos = flag.getBlockPos();
        FlagRenderInfo info = BetsyRossClient.getFlagRenderInfo(flag.getFlagId());
        int flagWidth = info.width;
        int flagHeight = info.height;
        if (state.is((Block)BetsyRossBlocks.FLAG_BLOCK.get())) {
            float dir = RotationSegment.convertToDegrees((int)((Integer)state.getValue((Property)FlagBlock.ROTATION)));
            float f1 = Mth.sin((float)(dir * ((float)Math.PI / 180)));
            float f2 = Mth.cos((float)(dir * ((float)Math.PI / 180)));
            return new AABB(pos).expandTowards((double)(f1 * (float)flagWidth), (double)flagHeight, (double)(f2 * (float)flagWidth)).inflate(1.0);
        }
        if (state.is((Block)BetsyRossBlocks.DRAPED_FLAG_BLOCK.get())) {
            Direction dir = (Direction)state.getValue((Property)DrapedFlagBlock.FACING);
            return AABB.encapsulatingFullBlocks((BlockPos)pos.relative(dir.getOpposite()), (BlockPos)pos.below(flagHeight).relative(dir.getCounterClockWise(), flagWidth)).inflate(1.0);
        }
        return new AABB(pos);
    }

    static {
        ALL_LAYERS = new HashSet<ModelLayerLocation>();
        ITEM_FLAGPOLE = BetsyRossClient.registerLayer("item_flagpole");
        ITEM_BANNER = BetsyRossClient.registerLayer("item_banner");
        ARMOR_FLAGPOLE = BetsyRossClient.registerLayer("armor_flagpole");
        SPECIAL_ARMOR_BANNER_MODEL = BetsyRoss.path("item/special_armor_banner");
        SPECIAL_BANNER_STANDARD_MODEL = BetsyRoss.path("item/special_banner_standard");
        SPECIAL_BANNER_STANDARD_RAISED_MODEL = BetsyRoss.path("item/special_banner_standard_raised");
        SPECIAL_FLAG_STANDARD_MODEL = BetsyRoss.path("item/special_flag_standard");
    }

    public record FlagRenderInfo(ResourceLocation location, int width, int height) {
    }
}

