/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.content;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.content.BetsyRossDataComponents;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockItem;
import rbasamoyai.betsyross.flags.standards.ArmorBannerItem;
import rbasamoyai.betsyross.flags.standards.StandardItem;
import rbasamoyai.betsyross.foundation.ObjectHolder;

public class BetsyRossItems {
    private static final Map<String, Supplier<? extends Item>> ENTRIES = new LinkedHashMap<String, Supplier<? extends Item>>();
    public static final Supplier<FlagBlockItem> FLAG_ITEM = BetsyRossItems.register("flag_block", () -> new FlagBlockItem(BetsyRossBlocks.FLAG_BLOCK.get(), (Block)BetsyRossBlocks.DRAPED_FLAG_BLOCK.get(), new Item.Properties().component(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG)));
    public static final Supplier<StandardItem> FLAG_STANDARD = BetsyRossItems.register("flag_standard", () -> new StandardItem(new Item.Properties().stacksTo(1).component(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG).component(BetsyRossDataComponents.RAISED.get(), (Object)false)));
    public static final Supplier<StandardItem> BANNER_STANDARD = BetsyRossItems.register("banner_standard", () -> new StandardItem(new Item.Properties().stacksTo(1).component(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG).component(BetsyRossDataComponents.RAISED.get(), (Object)false)));
    public static final Supplier<ArmorBannerItem> ARMOR_BANNER = BetsyRossItems.register("armor_banner", () -> new ArmorBannerItem(new Item.Properties().stacksTo(1).component(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG)));
    public static final Supplier<BlockItem> EMBROIDERY_TABLE_ITEM = BetsyRossItems.register("embroidery_table", () -> new BlockItem((Block)BetsyRossBlocks.EMBROIDERY_TABLE_BLOCK.get(), new Item.Properties()));

    private static <T extends Item> Supplier<T> register(String id, Supplier<T> item) {
        if (ENTRIES.containsKey(id)) {
            throw new IllegalStateException("Cannot register id '" + id + "' more than once");
        }
        ObjectHolder<T> holder = new ObjectHolder<T>(item);
        ENTRIES.put(id, holder);
        return holder;
    }

    public static void registerAll(BiConsumer<ResourceLocation, Item> cons) {
        for (Map.Entry<String, Supplier<? extends Item>> entry : ENTRIES.entrySet()) {
            cons.accept(BetsyRoss.path(entry.getKey()), entry.getValue().get());
        }
    }
}

