/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.crafting;

import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.betsyross.content.BetsyRossItems;
import rbasamoyai.betsyross.content.BetsyRossStats;
import rbasamoyai.betsyross.network.BetsyRossNetworkHandler;
import rbasamoyai.betsyross.network.s2c.S2COpenEmbroideryTableScreenPayload;

public class EmbroideryTableBlock
extends Block {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)12.0, (double)5.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0), Block.box((double)1.0, (double)0.0, (double)11.0, (double)5.0, (double)12.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)12.0, (double)15.0)});

    public EmbroideryTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack itemStack = player.getItemInHand(hand);
            if (EmbroideryTableBlock.isValidEmbroideryTableItem(itemStack)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer splayer = (ServerPlayer)player;
                    BetsyRossNetworkHandler.sendToClient(splayer, new S2COpenEmbroideryTableScreenPayload(player.getInventory().selected, Configs.COMMON.minPaintingResolution, Configs.COMMON.maxPaintingResolution, Configs.COMMON.showOtherPlayersPaintings, Configs.COMMON.uploadPermissionLevel));
                    player.awardStat(BetsyRossStats.INTERACT_WITH_EMBROIDERY_TABLE);
                }
            } else if (EmbroideryTableBlock.isInvalidFlagItem(itemStack)) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.betsyross.embroidery_table.invalid_flag"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"gui.betsyross.embroidery_table.invalid_item"), true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static BlockBehaviour.Properties blockProperties() {
        return BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD).mapColor(MapColor.WOOD);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public static boolean isValidEmbroideryTableItem(ItemStack itemStack) {
        if (itemStack.is((Item)BetsyRossItems.FLAG_STANDARD.get())) {
            return true;
        }
        if (itemStack.is((Item)BetsyRossItems.BANNER_STANDARD.get())) {
            return true;
        }
        return itemStack.is((Item)BetsyRossItems.ARMOR_BANNER.get());
    }

    public static boolean isInvalidFlagItem(ItemStack itemStack) {
        return itemStack.is((Item)BetsyRossItems.FLAG_ITEM.get());
    }
}

