/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.client.gui.widget.IntegerSliderWidget;
import net.conczin.immersive_paintings.client.gui.widget.PaintingWidget;
import net.conczin.immersive_paintings.client.gui.widget.PercentageSliderWidget;
import net.conczin.immersive_paintings.network.LazyNetworkManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.c2s.ImageUploadPayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingDeletePayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingRegisterPayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingRegisterErrorPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.flags.BetsyRossFlagScreen;
import rbasamoyai.betsyross.mixin.client.PixelatorSettingsAccessor;

public abstract class AbstractFlagScreen
extends Screen
implements BetsyRossFlagScreen {
    protected static final int SCREENSHOTS_PER_PAGE = 5;
    protected final int minResolution;
    protected final int maxResolution;
    protected final boolean showOtherPlayersPaintings;
    protected final int uploadPermissionLevel;
    protected String filteredString = "";
    protected int filteredResolution = 0;
    protected int filteredWidth = 0;
    protected int filteredHeight = 0;
    protected final List<ResourceLocation> filteredPaintings = new ArrayList<ResourceLocation>();
    protected int selectionPage;
    protected ImmersivePaintingScreen.Page page;
    protected Button pageWidget;
    protected final Map<ResourceLocation, PaintingWidget> paintingWidgets = new HashMap<ResourceLocation, PaintingWidget>();
    protected BufferedImage currentImage;
    protected static int currentImagePixelZoomCache = -1;
    protected String currentImageName;
    protected ImmersivePaintingScreen.PixelatorSettings settings;
    protected BufferedImage pixelatedImage;
    protected List<File> screenshots = List.of();
    protected int screenshotPage;
    protected ResourceLocation deletePainting;
    protected Component error;
    protected boolean shouldReProcess;
    protected static volatile boolean shouldUpload;
    private static final ExecutorService service;

    protected AbstractFlagScreen(int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) {
        super((Component)Component.translatable((String)"block.betsyross.flag_block"));
        this.minResolution = minResolution;
        this.maxResolution = maxResolution;
        this.showOtherPlayersPaintings = showOtherPlayersPaintings;
        this.uploadPermissionLevel = uploadPermissionLevel;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        if (this.page == null) {
            this.setPage(ImmersivePaintingScreen.Page.DATAPACKS);
        } else {
            this.refreshPage();
        }
        File file = new File(Minecraft.getInstance().gameDirectory, "screenshots");
        File[] files = file.listFiles(v -> v.getName().endsWith(".png"));
        if (files != null) {
            this.screenshots = Arrays.stream(files).toList();
        }
    }

    protected void clearSearch() {
        this.filteredString = "";
        this.filteredResolution = 0;
        this.filteredWidth = 0;
        this.filteredHeight = 0;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        switch (this.page) {
            case NEW: {
                context.fill(this.width / 2 - 115, this.height / 2 - 68, this.width / 2 + 115, this.height / 2 - 41, 0x50000000);
                List wrap = ImmersivePaintingScreen.wrap((Component)Component.translatable((String)"immersive_paintings.gui.drop"), (int)220);
                int y = this.height / 2 - 40 - wrap.size() * 12;
                for (Component text : wrap) {
                    context.drawCenteredString(this.font, text, this.width / 2, y, -1);
                    y += 12;
                }
                break;
            }
            case CREATE: {
                if (this.shouldReProcess && this.currentImage != null) {
                    service.submit(this::pixellateImage);
                    this.shouldReProcess = false;
                }
                if (shouldUpload && this.pixelatedImage != null) {
                    Minecraft.getInstance().getTextureManager().register(Main.locate((String)"temp_pixelated"), (AbstractTexture)new DynamicTexture(ImageManipulations.bufferedToNative((BufferedImage)this.pixelatedImage)));
                }
                int maxWidth = 190;
                int maxHeight = 135;
                int tw = this.settings.resolution * this.settings.width;
                int th = this.settings.resolution * this.settings.height;
                float size = Math.min((float)maxWidth / (float)tw, (float)maxHeight / (float)th);
                PoseStack matrices = context.pose();
                matrices.pushPose();
                matrices.translate((float)this.width / 2.0f - (float)tw * size / 2.0f, (float)this.height / 2.0f - (float)th * size / 2.0f, 0.0f);
                matrices.scale(size, size, 1.0f);
                context.blit(Main.locate((String)"temp_pixelated"), 0, 0, 0.0f, 0.0f, tw, th, tw, th);
                matrices.popPose();
                if (this.error == null) break;
                context.drawCenteredString(this.font, this.error, this.width / 2, this.height / 2, -65536);
                break;
            }
            case DELETE: {
                context.fill(this.width / 2 - 160, this.height / 2 - 50, this.width / 2 + 160, this.height / 2 + 50, -2013265920);
                List wrap = ImmersivePaintingScreen.wrap((Component)Component.translatable((String)"immersive_paintings.gui.confirm_deletion"), (int)300);
                int y = this.height / 2 - 35;
                for (Component t : wrap) {
                    context.drawCenteredString(this.font, t, this.width / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case ADMIN_DELETE: {
                context.fill(this.width / 2 - 160, this.height / 2 - 50, this.width / 2 + 160, this.height / 2 + 50, -2013265920);
                List wrap = ImmersivePaintingScreen.wrap((Component)Component.translatable((String)"immersive_paintings.gui.confirm_admin_deletion"), (int)300);
                int y = this.height / 2 - 35;
                for (Component t : wrap) {
                    context.drawCenteredString(this.font, t, this.width / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case LOADING: {
                MutableComponent text = Component.translatable((String)"immersive_paintings.gui.upload", (Object[])new Object[]{(int)Math.ceil(LazyNetworkManager.getRemainingTime())});
                context.drawCenteredString(this.font, (Component)text, this.width / 2, this.height / 2, -1);
            }
        }
    }

    private void pixellateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage((BufferedImage)this.currentImage, (ImmersivePaintingScreen.PixelatorSettings)this.settings);
        shouldUpload = true;
    }

    protected void rebuild() {
        int x;
        this.clearWidgets();
        if (this.page != ImmersivePaintingScreen.Page.CREATE) {
            LinkedList<ImmersivePaintingScreen.Page> b = new LinkedList<ImmersivePaintingScreen.Page>();
            b.add(ImmersivePaintingScreen.Page.YOURS);
            b.add(ImmersivePaintingScreen.Page.DATAPACKS);
            if (this.showOtherPlayersPaintings || this.isOp()) {
                b.add(ImmersivePaintingScreen.Page.PLAYERS);
            }
            if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.hasPermissions(this.uploadPermissionLevel)) {
                b.add(ImmersivePaintingScreen.Page.NEW);
            }
            x = this.width / 2 - 200;
            int w = 400 / b.size();
            for (ImmersivePaintingScreen.Page page : b) {
                Button btn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)("immersive_paintings.gui.page." + page.name().toLowerCase(Locale.ROOT))), sender -> this.setPage(page)).bounds(x, this.height / 2 - 90 - 22, w, 20).build());
                btn.active = page != this.page;
                x += w;
            }
        }
        if (this.page == ImmersivePaintingScreen.Page.FRAME) {
            this.page = ImmersivePaintingScreen.Page.DATAPACKS;
        }
        switch (this.page) {
            case NEW: {
                EditBox editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 90, this.height / 2 - 38, 180, 16, (Component)Component.literal((String)"URL")));
                editBox.setMaxLength(1024);
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.load"), sender -> this.loadImage(editBox.getValue())).bounds(this.width / 2 - 50, this.height / 2 - 15, 100, 20).build());
                this.rebuildScreenshots();
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<<"), sender -> this.setScreenshotPage(this.screenshotPage - 1)).bounds(this.width / 2 - 65, this.height / 2 + 70, 30, 20).build());
                this.pageWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), sender -> {}).bounds(this.width / 2 - 65 + 30, this.height / 2 + 70, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">>"), sender -> this.setScreenshotPage(this.screenshotPage + 1)).bounds(this.width / 2 - 65 + 100, this.height / 2 + 70, 30, 20).build());
                this.setScreenshotPage(this.screenshotPage);
                break;
            }
            case CREATE: {
                EditBox editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 90, this.height / 2 - 100, 180, 20, (Component)Component.translatable((String)"immersive_paintings.gui.name")));
                editBox.setMaxLength(256);
                editBox.setValue(this.currentImageName);
                editBox.setResponder(s -> {
                    this.currentImageName = s;
                });
                int y = this.height / 2 - 60;
                this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget(this.width / 2 - 200, y, 100, 20, "immersive_paintings.gui.width", (double)this.settings.width, 1, 16, v -> {
                    this.settings.width = v;
                    this.shouldReProcess = true;
                }));
                this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget(this.width / 2 - 200, y += 22, 100, 20, "immersive_paintings.gui.height", (double)this.settings.height, 1, 16, v -> {
                    this.settings.height = v;
                    this.shouldReProcess = true;
                }));
                int x2 = this.width / 2 - 200;
                Button resolutionWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)String.valueOf(this.settings.resolution)), v -> {}).bounds(x2 + 25, y += 22, 50, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), v -> {
                    this.settings.resolution = Math.max(this.minResolution, this.settings.resolution / 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    resolutionWidget.setMessage((Component)Component.literal((String)String.valueOf(this.settings.resolution)));
                }).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.resolution"))).bounds(x2, y, 25, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), v -> {
                    this.settings.resolution = Math.min(this.maxResolution, this.settings.resolution * 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    resolutionWidget.setMessage((Component)Component.literal((String)String.valueOf(this.settings.resolution)));
                }).bounds(x2 + 75, y, 25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.resolution"))).build());
                y += 22;
                ((IntegerSliderWidget)this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget((int)(this.width / 2 - 200), (int)(y += 10), (int)100, (int)20, (String)"immersive_paintings.gui.colors", (double)((double)this.settings.colors), (int)1, (int)25, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$12(java.lang.Integer ), (Ljava/lang/Integer;)V)((AbstractFlagScreen)this)))).active = !this.settings.pixelArt;
                ((PercentageSliderWidget)this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget((int)(this.width / 2 - 200), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.gui.dither", (double)this.settings.dither, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$13(java.lang.Double ), (Ljava/lang/Double;)V)((AbstractFlagScreen)this)))).active = !this.settings.pixelArt;
                y = this.height / 2 - 50;
                this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"immersive_paintings.gui.pixelart"), (Font)this.font).pos(this.width / 2 + 100, y).selected(this.settings.pixelArt).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.pixelart.tooltip"))).onValueChange((widget, value) -> {
                    this.settings.pixelArt = value;
                    this.adaptToPixelArt();
                    this.refreshPage();
                    this.shouldReProcess = true;
                }).build());
                this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"immersive_paintings.gui.hide"), (Font)this.font).pos(this.width / 2 + 100, y += 22).selected(this.settings.hidden).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.visibility"))).onValueChange((widget, value) -> {
                    this.settings.hidden = !this.settings.hidden;
                }).build());
                this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"immersive_paintings.gui.nsfw"), (Font)this.font).pos(this.width / 2 + 100, y += 22).selected(this.settings.nsfw).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.nsfw"))).onValueChange((widget, value) -> {
                    this.settings.nsfw = !this.settings.nsfw;
                }).build());
                this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget(this.width / 2 + 100, y += 22, 100, 20, "immersive_paintings.gui.x_offset", this.settings.offsetX, v -> {
                    this.settings.offsetX = v;
                    this.shouldReProcess = true;
                }));
                this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget(this.width / 2 + 100, y += 22, 100, 20, "immersive_paintings.gui.y_offset", this.settings.offsetY, v -> {
                    this.settings.offsetY = v;
                    this.shouldReProcess = true;
                }));
                ((PercentageSliderWidget)this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget((int)(this.width / 2 + 100), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.gui.zoom", (double)this.settings.zoom, (double)1.0, (double)3.0, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$19(java.lang.Double ), (Ljava/lang/Double;)V)((AbstractFlagScreen)this)))).active = !this.settings.pixelArt;
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.cancel"), v -> this.setPage(ImmersivePaintingScreen.Page.NEW)).bounds(this.width / 2 - 85, this.height / 2 + 75, 80, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.save"), v -> {
                    byte[] encoded;
                    int maxWidth = this.getConfigWidth();
                    int maxHeight = this.getConfigHeight();
                    if (maxWidth != 0 && this.settings.width > maxWidth) {
                        this.setError((Component)Component.translatable((String)"gui.betsyross.flag_maker.too_wide", (Object[])new Object[]{Math.max(0, maxWidth)}));
                        return;
                    }
                    if (maxHeight != 0 && this.settings.height > maxHeight) {
                        this.setError((Component)Component.translatable((String)"gui.betsyross.flag_maker.too_tall", (Object[])new Object[]{Math.max(0, maxHeight)}));
                        return;
                    }
                    try {
                        encoded = ImageManipulations.encode((BufferedImage)this.pixelatedImage);
                    }
                    catch (IOException e) {
                        BetsyRoss.LOGGER.error("could not encode temp image", (Throwable)e);
                        return;
                    }
                    ImageManipulations.processByteArrayInChunks((byte[])encoded, (ints, split, splits) -> LazyNetworkManager.sendToServer((ImmersivePayload)new ImageUploadPayload(ints, split.intValue(), splits.intValue())));
                    LazyNetworkManager.sendToServer((ImmersivePayload)new PaintingRegisterPayload(this.settings.width, this.settings.height, this.settings.resolution, this.currentImageName, this.settings.getFlags()));
                    this.setPage(ImmersivePaintingScreen.Page.LOADING);
                }).bounds(this.width / 2 + 5, this.height / 2 + 75, 80, 20).build());
                break;
            }
            case YOURS: 
            case DATAPACKS: 
            case PLAYERS: {
                this.rebuildPaintings();
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<<"), sender -> this.setSelectionPage(this.selectionPage - 1)).bounds(this.width / 2 - 35 - 30, this.height / 2 + 80, 30, 20).build());
                this.pageWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), sender -> {}).bounds(this.width / 2 - 35, this.height / 2 + 80, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">>"), sender -> this.setSelectionPage(this.selectionPage + 1)).bounds(this.width / 2 + 35, this.height / 2 + 80, 30, 20).build());
                this.setSelectionPage(this.selectionPage);
                EditBox searchBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 65, this.height / 2 - 88, 130, 16, (Component)Component.translatable((String)"immersive_paintings.gui.search")));
                searchBox.setMaxLength(64);
                searchBox.setSuggestion("search");
                searchBox.setResponder(s -> {
                    this.filteredString = s;
                    this.updateSearch();
                    searchBox.setSuggestion(null);
                });
                x = this.width / 2 - 200 + 12;
                Button widget2 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)String.valueOf(this.filteredResolution)), v -> {}).bounds(x + 50 + 8, this.height / 2 - 90, 25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                Button allWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.filter_all"), v -> {
                    this.filteredResolution = 0;
                    this.updateSearch();
                    widget2.setMessage((Component)Component.literal((String)String.valueOf(this.filteredResolution)));
                    v.active = false;
                }).bounds(x, this.height / 2 - 90, 25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.max(this.minResolution, this.filteredResolution / 2);
                    this.updateSearch();
                    widget2.setMessage((Component)Component.literal((String)String.valueOf(this.filteredResolution)));
                    allWidget.active = true;
                }).bounds(x + 25 + 8, this.height / 2 - 90, 25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.min(this.maxResolution, this.filteredResolution * 2);
                    this.updateSearch();
                    widget2.setMessage((Component)Component.literal((String)String.valueOf(this.filteredResolution)));
                    allWidget.active = true;
                }).bounds(x + 75 + 8, this.height / 2 - 90, 25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                EditBox widthInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 80, this.height / 2 - 88, 40, 16, (Component)Component.translatable((String)"immersive_paintings.gui.filter_width")));
                widthInput.setMaxLength(2);
                widthInput.setSuggestion("width");
                widthInput.setResponder(s -> {
                    try {
                        this.filteredWidth = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredWidth = 0;
                    }
                    this.updateSearch();
                    widthInput.setSuggestion(null);
                });
                EditBox heightInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 80 + 40, this.height / 2 - 88, 40, 16, (Component)Component.translatable((String)"immersive_paintings.gui.filter_height")));
                heightInput.setMaxLength(2);
                heightInput.setSuggestion("height");
                heightInput.setResponder(s -> {
                    try {
                        this.filteredHeight = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredHeight = 0;
                    }
                    this.updateSearch();
                    heightInput.setSuggestion(null);
                });
                break;
            }
            case DELETE: {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.cancel"), v -> this.setPage(ImmersivePaintingScreen.Page.YOURS)).bounds(this.width / 2 - 100 - 5, this.height / 2 + 20, 100, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.delete"), v -> {
                    NetworkHandler.Client.sendToServer((ImmersivePayload)new PaintingDeletePayload(this.deletePainting, false));
                    this.setPage(ImmersivePaintingScreen.Page.YOURS);
                }).bounds(this.width / 2 + 5, this.height / 2 + 20, 100, 20).build());
                break;
            }
            case ADMIN_DELETE: {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.cancel"), v -> this.setPage(ImmersivePaintingScreen.Page.PLAYERS)).bounds(this.width / 2 - 115, this.height / 2 + 10, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.delete"), v -> {
                    NetworkHandler.Client.sendToServer((ImmersivePayload)new PaintingDeletePayload(this.deletePainting, false));
                    this.setPage(ImmersivePaintingScreen.Page.PLAYERS);
                }).bounds(this.width / 2 - 40, this.height / 2 + 10, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.delete_all"), v -> {
                    NetworkHandler.Client.sendToServer((ImmersivePayload)new PaintingDeletePayload(this.deletePainting, true));
                    this.setPage(ImmersivePaintingScreen.Page.PLAYERS);
                }).bounds(this.width / 2 + 35, this.height / 2 + 10, 70, 20).build());
            }
        }
    }

    public void updateWidget(ResourceLocation paintingLoc) {
        if (this.paintingWidgets.containsKey(paintingLoc)) {
            ClientPaintingManager.getPainting((ResourceLocation)paintingLoc).ifPresent(p -> this.paintingWidgets.get(paintingLoc).update(ClientPaintingManager.getImageIdentifier((ResourceLocation)paintingLoc, (Painting.Size)Painting.Size.THUMBNAIL), p.width(), p.height()));
        }
    }

    private static Component consolidate(List<Component> textList) {
        if (textList == null) {
            return null;
        }
        MutableComponent base = Component.empty();
        MutableComponent lastTextNode = base.copy();
        if (textList.isEmpty()) {
            return base;
        }
        for (int i = 0; i < textList.size() - 1; ++i) {
            Component text = textList.get(i);
            lastTextNode = lastTextNode.append(text).append("\n");
        }
        Component finalElement = textList.getLast();
        return lastTextNode.append(finalElement);
    }

    protected void rebuildPaintings() {
        for (PaintingWidget w : this.paintingWidgets.values()) {
            this.removeWidget((GuiEventListener)w);
        }
        this.paintingWidgets.clear();
        for (int y = 0; y < 3; ++y) {
            int i;
            for (int x = 0; x < 8 && (i = y * 8 + x + this.selectionPage * 24) >= 0 && i < this.filteredPaintings.size(); ++x) {
                ResourceLocation paintingLoc = this.filteredPaintings.get(i);
                LinkedList<Component> tooltip = new LinkedList<Component>();
                Optional paintingOp = ClientPaintingManager.getPainting((ResourceLocation)paintingLoc);
                if (paintingOp.isPresent()) {
                    Painting painting = (Painting)paintingOp.get();
                    tooltip.add((Component)Component.literal((String)painting.name()));
                    tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.by_author", (Object[])new Object[]{painting.author()}).withStyle(ChatFormatting.ITALIC));
                    tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.resolution", (Object[])new Object[]{painting.width(), painting.height(), painting.resolution()}).withStyle(ChatFormatting.ITALIC));
                    if (this.page == ImmersivePaintingScreen.Page.YOURS && painting.has(Painting.Flag.HIDDEN)) {
                        tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.hidden").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                    if (this.page == ImmersivePaintingScreen.Page.YOURS && painting.has(Painting.Flag.NSFW)) {
                        tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.nsfw").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                    if (this.page == ImmersivePaintingScreen.Page.YOURS || this.page == ImmersivePaintingScreen.Page.PLAYERS && this.isOp()) {
                        tooltip.add((Component)Component.translatable((String)"immersive_paintings.right_click_to_delete").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                }
                PaintingWidget paintingWidget = (PaintingWidget)this.addRenderableWidget((GuiEventListener)new PaintingWidget((int)((double)(this.width / 2) + ((double)x - 3.5) * 48.0) - 24, this.height / 2 - 66 + y * 48, 46, 46, sender -> {
                    if (this.canUpdateFlag()) {
                        this.updateFlag(paintingLoc);
                    }
                    this.onClose();
                }, b -> {
                    if (this.page == ImmersivePaintingScreen.Page.YOURS) {
                        this.deletePainting = paintingLoc;
                        this.setPage(ImmersivePaintingScreen.Page.DELETE);
                    } else if (this.page == ImmersivePaintingScreen.Page.PLAYERS && this.isOp()) {
                        this.deletePainting = paintingLoc;
                        this.setPage(ImmersivePaintingScreen.Page.ADMIN_DELETE);
                    }
                }));
                paintingWidget.setTooltip(Tooltip.create((Component)AbstractFlagScreen.consolidate(tooltip)));
                this.paintingWidgets.put(paintingLoc, paintingWidget);
                this.updateWidget(paintingLoc);
            }
        }
    }

    protected void rebuildScreenshots() {
        int i;
        for (PaintingWidget w : this.paintingWidgets.values()) {
            this.removeWidget((GuiEventListener)w);
        }
        this.paintingWidgets.clear();
        for (int x = 0; x < 5 && (i = x + this.screenshotPage * 5) >= 0 && i < this.screenshots.size(); ++x) {
            File file = this.screenshots.get(i);
            PaintingWidget paintingWidget = (PaintingWidget)this.addRenderableWidget((GuiEventListener)new PaintingWidget(this.width / 2 + (x - 2) * 68 - 32, this.height / 2 + 15, 64, 48, b -> {
                this.currentImage = ((PaintingWidget)b).getImage();
                if (this.currentImage != null) {
                    currentImagePixelZoomCache = -1;
                    this.currentImageName = file.getName();
                    this.settings = PixelatorSettingsAccessor.callInit(this.currentImage, this.minResolution, this.maxResolution);
                    this.setPage(ImmersivePaintingScreen.Page.CREATE);
                    this.pixelateImage();
                }
            }, b -> {}));
            paintingWidget.setTooltip(Tooltip.create((Component)Component.literal((String)file.getName())));
            ResourceLocation loc = Main.locate((String)("screenshot_" + x));
            this.paintingWidgets.put(loc, paintingWidget);
            service.submit(() -> {
                BufferedImage image = this.loadImage(file.getPath(), loc);
                if (image != null) {
                    paintingWidget.update(loc, image);
                }
            });
        }
    }

    public void setPage(ImmersivePaintingScreen.Page page) {
        this.clearError();
        if (page != this.page) {
            this.clearSearch();
        }
        this.page = page;
        this.filteredResolution = page == ImmersivePaintingScreen.Page.DATAPACKS ? 32 : 0;
        this.rebuild();
        if (page == ImmersivePaintingScreen.Page.DATAPACKS || page == ImmersivePaintingScreen.Page.PLAYERS || page == ImmersivePaintingScreen.Page.YOURS) {
            this.updateSearch();
        }
    }

    protected void updateSearch() {
        this.filteredPaintings.clear();
        int maxWidth = this.getConfigWidth();
        int maxHeight = this.getConfigHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        UUID uuid = player == null ? null : player.getUUID();
        boolean isOp = this.isOp();
        this.filteredPaintings.addAll(ClientPaintingManager.getPaintings().entrySet().stream().filter(entry -> {
            Painting painting = (Painting)entry.getValue();
            return !((this.page != ImmersivePaintingScreen.Page.YOURS || painting.is(Painting.Type.DATAPACK) || !painting.authorUUID().equals(uuid)) && (this.page != ImmersivePaintingScreen.Page.PLAYERS || painting.is(Painting.Type.DATAPACK) || painting.has(Painting.Flag.HIDDEN) && !isOp || painting.has(Painting.Flag.NSFW) && !Configs.CLIENT.showNSFWPaintings && !isOp) && (this.page != ImmersivePaintingScreen.Page.DATAPACKS || !painting.is(Painting.Type.DATAPACK)) || !((ResourceLocation)entry.getKey()).toString().contains(this.filteredString) || this.filteredResolution != 0 && painting.resolution() != this.filteredResolution || this.filteredWidth != 0 && painting.width() != this.filteredWidth || this.filteredHeight != 0 && painting.height() != this.filteredHeight || maxWidth != 0 && painting.width() > maxWidth || maxHeight != 0 && painting.height() > maxHeight);
        }).sorted(Comparator.comparing(p -> ((Painting)p.getValue()).name())).map(Map.Entry::getKey).toList());
        this.setSelectionPage(this.selectionPage);
    }

    protected abstract int getConfigWidth();

    protected abstract int getConfigHeight();

    protected boolean isOp() {
        return Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasPermissions(4);
    }

    protected void setSelectionPage(int p) {
        this.selectionPage = Math.min(this.getMaxPages() - 1, Math.max(0, p));
        this.rebuildPaintings();
        this.pageWidget.setMessage((Component)Component.literal((String)(this.selectionPage + 1 + " / " + this.getMaxPages())));
    }

    protected int getMaxPages() {
        return (int)Math.ceil((double)this.filteredPaintings.size() / 24.0);
    }

    protected void setScreenshotPage(int p) {
        int oldPage = this.screenshotPage;
        this.screenshotPage = Math.min(this.getScreenshotMaxPages() - 1, Math.max(0, p));
        if (oldPage != this.screenshotPage) {
            this.rebuildScreenshots();
        }
        this.pageWidget.setMessage((Component)Component.literal((String)(this.screenshotPage + 1 + " / " + this.getScreenshotMaxPages())));
    }

    protected int getScreenshotMaxPages() {
        return (int)Math.ceil((double)this.screenshots.size() / 8.0);
    }

    public void onFilesDrop(List<Path> paths) {
        Path path = paths.get(0);
        this.loadImage(path.toString());
    }

    protected void loadImage(String path) {
        this.currentImage = this.loadImage(path, Main.locate((String)"temp"));
        currentImagePixelZoomCache = -1;
        if (this.currentImage != null) {
            this.currentImageName = FilenameUtils.getBaseName((String)path).replaceFirst("[.][^.]+$", "");
            this.settings = PixelatorSettingsAccessor.callInit(this.currentImage, this.minResolution, this.maxResolution);
            this.setPage(ImmersivePaintingScreen.Page.CREATE);
            this.pixelateImage();
        }
    }

    protected BufferedImage loadImage(String path, ResourceLocation loc) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                BetsyRoss.LOGGER.error("failed loading image {} from path {}", new Object[]{loc, path, e});
            }
        }
        if (stream != null) {
            try {
                BufferedImage nativeImage = ImageIO.read(stream);
                Minecraft.getInstance().getTextureManager().register(loc, (AbstractTexture)new DynamicTexture(ImageManipulations.bufferedToNative((BufferedImage)nativeImage)));
                stream.close();
                return nativeImage;
            }
            catch (IOException e) {
                BetsyRoss.LOGGER.error("failed decoding image {} from path {}", new Object[]{loc, path, e});
            }
        }
        return null;
    }

    protected static int getCurrentImagePixelZoomCache(BufferedImage currentImage) {
        if (currentImagePixelZoomCache < 0) {
            currentImagePixelZoomCache = ImageManipulations.scanForPixelArtMultiple((BufferedImage)currentImage);
        }
        return currentImagePixelZoomCache;
    }

    protected void pixelateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage((BufferedImage)this.currentImage, (ImmersivePaintingScreen.PixelatorSettings)this.settings);
        shouldUpload = true;
    }

    protected void adaptToPixelArt() {
        double zoom = AbstractFlagScreen.getCurrentImagePixelZoomCache(this.currentImage);
        this.settings.width = Math.max(1, Math.min(16, (int)((double)this.currentImage.getWidth() / zoom / (double)this.settings.resolution)));
        this.settings.height = Math.max(1, Math.min(16, (int)((double)this.currentImage.getHeight() / zoom / (double)this.settings.resolution)));
    }

    @Override
    public void onReceivePaintingResponse(PaintingRegisterErrorPayload response) {
        if (response.error().isEmpty()) {
            if (this.canUpdateFlag() && response.identifier().isPresent()) {
                this.updateFlag((ResourceLocation)response.identifier().get());
            }
            this.onClose();
        } else {
            this.setPage(ImmersivePaintingScreen.Page.CREATE);
            this.setError((Component)Component.translatable((String)("immersive_paintings.error." + response.error())));
        }
    }

    protected abstract void updateFlag(ResourceLocation var1);

    protected abstract boolean canUpdateFlag();

    @Override
    public void refreshPage() {
        this.setPage(this.page);
    }

    public void setError(Component error) {
        this.error = error;
    }

    protected void clearError() {
        this.error = null;
    }

    private /* synthetic */ void lambda$rebuild$19(Double v) {
        this.settings.zoom = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$13(Double v) {
        this.settings.dither = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$12(Integer v) {
        this.settings.colors = v;
        this.shouldReProcess = true;
    }

    static {
        service = Executors.newFixedThreadPool(1);
    }
}

