/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags.flag_block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.network.BetsyRossNetworkHandler;
import rbasamoyai.betsyross.network.s2c.S2COpenFlagBlockScreenPayload;
import rbasamoyai.betsyross.tags.BetsyRossTags;

public class FlagBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<FlagBlock> CODEC = FlagBlock.simpleCodec(FlagBlock::new);
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;

    public FlagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ROTATION}).add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(-context.getRotation() + 180.0f))));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FlagBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ServerPlayer splayer;
        FlagBlockEntity flag;
        block10: {
            block9: {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof FlagBlockEntity)) {
                    return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
                }
                flag = (FlagBlockEntity)blockEntity;
                if (level.isClientSide || !(player instanceof ServerPlayer)) break block9;
                splayer = (ServerPlayer)player;
                if (splayer.gameMode.getGameModeForPlayer() != GameType.ADVENTURE) break block10;
            }
            return ItemInteractionResult.SUCCESS;
        }
        boolean sneaking = player.isShiftKeyDown();
        boolean emptyFlagPole = flag.getFlagPole().isAir();
        if (stack.isEmpty() && !emptyFlagPole && !sneaking) {
            BlockState oldFlagpole = flag.getFlagPole();
            flag.setFlagPole(Blocks.AIR.defaultBlockState());
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                player.addItem(oldFlagpole.getBlock().getCloneItemStack((LevelReader)level, pos, oldFlagpole));
            }
            return ItemInteractionResult.CONSUME;
        }
        Item oldFlagpole = stack.getItem();
        if (oldFlagpole instanceof BlockItem) {
            BlockItem item = (BlockItem)oldFlagpole;
            if (emptyFlagPole && FlagBlock.isFlagpole(item.getBlock()) && !sneaking) {
                BlockState state1 = item.getBlock().defaultBlockState();
                flag.setFlagPole(state1);
                SoundType soundType = state1.getSoundType();
                level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.CONSUME;
            }
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        BetsyRossNetworkHandler.sendToClient(splayer, new S2COpenFlagBlockScreenPayload(pos, Configs.COMMON.minPaintingResolution, Configs.COMMON.maxPaintingResolution, Configs.COMMON.showOtherPlayersPaintings, Configs.COMMON.uploadPermissionLevel));
        return ItemInteractionResult.CONSUME;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid() || level.getBlockState(pos.below()).is((Block)BetsyRossBlocks.FLAG_BLOCK.get());
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        return dir == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, dir, otherState, level, pos, otherPos);
    }

    public static boolean isFlagpole(Block block) {
        return block.defaultBlockState().is(BetsyRossTags.FLAGPOLE);
    }

    public static BlockBehaviour.Properties blockProperties() {
        return BlockBehaviour.Properties.of().sound(SoundType.WOOL).mapColor(MapColor.WOOL).noCollission().noOcclusion().instabreak();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        FlagBlockEntity flag;
        ItemStack itemStack;
        List list = super.getDrops(state, params);
        BlockEntity be = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (be instanceof FlagBlockEntity && !(itemStack = new ItemStack((ItemLike)(flag = (FlagBlockEntity)be).getFlagPole().getBlock())).isEmpty()) {
            list.add(itemStack);
        }
        return list;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

