/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags.flag_block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.BetsyRossClient;
import rbasamoyai.betsyross.config.BetsyRossConfig;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.flags.flag_block.DrapedFlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagAnimationDetail;
import rbasamoyai.betsyross.flags.flag_block.FlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.remix.CulledRenderBBBlockEntity;
import rbasamoyai.betsyross.remix.FrustumCache;

public class FlagBlockEntityRenderer
implements BlockEntityRenderer<FlagBlockEntity> {
    private final BlockRenderDispatcher brd;

    public FlagBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.brd = ctx.getBlockRenderDispatcher();
    }

    public void render(FlagBlockEntity flag, float partialTicks, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        CulledRenderBBBlockEntity culled;
        if (flag instanceof CulledRenderBBBlockEntity && !FrustumCache.isVisible((culled = (CulledRenderBBBlockEntity)((Object)flag)).getRenderBox())) {
            return;
        }
        ResourceLocation flagId = flag.getFlagId();
        BetsyRossClient.FlagRenderInfo renderInfo = BetsyRossClient.getFlagRenderInfo(flagId);
        int w = renderInfo.width();
        int h = renderInfo.height();
        BlockState state = flag.getBlockState();
        Minecraft mc = Minecraft.getInstance();
        double distance = mc.player == null ? 0.0 : Math.sqrt(mc.player.distanceToSqr(Vec3.atCenterOf((Vec3i)flag.getBlockPos())));
        stack.pushPose();
        if (state.is((Block)BetsyRossBlocks.FLAG_BLOCK.get())) {
            float dir = RotationSegment.convertToDegrees((int)((Integer)state.getValue((Property)FlagBlock.ROTATION)));
            FlagAnimationDetail detail = BetsyRossConfig.CLIENT.animationDetail;
            stack.pushPose();
            stack.translate(0.5, (double)h, 0.5);
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, dir, stack, buffers, packedLight, packedOverlay, false, detail, false);
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, dir, stack, buffers, packedLight, packedOverlay, true, detail, false);
            stack.popPose();
            BlockState flagpole = flag.getFlagPole();
            if (flagpole != null) {
                this.brd.renderSingleBlock(flagpole, stack, buffers, packedLight, packedOverlay);
            }
        } else if (state.is((Block)BetsyRossBlocks.DRAPED_FLAG_BLOCK.get())) {
            Direction dir = (Direction)state.getValue((Property)DrapedFlagBlock.FACING);
            Direction dir1 = dir.getAxis() == Direction.Axis.X ? dir.getCounterClockWise() : dir.getClockWise();
            float f = dir1.toYRot();
            stack.translate(0.0f, 1.0f, 0.0f);
            if (dir == Direction.WEST || dir == Direction.NORTH) {
                stack.translate(1.0f, 0.0f, 0.0f);
            }
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                stack.translate(0.0f, 0.0f, 1.0f);
            }
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, f, stack, buffers, packedLight, packedOverlay, false, FlagAnimationDetail.NO_WAVE, false);
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, f, stack, buffers, packedLight, packedOverlay, true, FlagAnimationDetail.NO_WAVE, false);
        }
        stack.popPose();
    }

    public static void renderFullTexture(ResourceLocation flagId, double distance, int width, int height, float partialTicks, float dir, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay, boolean flip, FlagAnimationDetail detail, boolean isItem) {
        if (width <= 0 || height <= 0) {
            return;
        }
        stack.pushPose();
        Vector3f v3f = new Vector3f(0.0f, 0.0f, 0.0f);
        v3f.mulTransposePosition((Matrix4fc)stack.last().pose());
        stack.translate(-v3f.x(), -v3f.y(), -v3f.z());
        stack.mulPose(Axis.YP.rotationDegrees(dir - 90.0f));
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        stack.translate(v3f.x(), v3f.y(), v3f.z());
        stack.translate(0.0, 0.0, flip ? -0.01 : 0.01);
        VertexConsumer vcons = buffers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)FlagBlockEntityRenderer.getFlagLocation(flagId, distance)));
        switch (detail) {
            case NO_WAVE: {
                FlagBlockEntityRenderer.renderSimple(vcons, stack, width, height, packedLight, packedOverlay, flip, isItem);
                break;
            }
            case WAVE: {
                FlagBlockEntityRenderer.renderWaveSimple(vcons, stack, partialTicks, width, height, packedLight, packedOverlay, flip);
            }
        }
        stack.popPose();
    }

    private static void renderSimple(VertexConsumer vcons, PoseStack stack, int w, int h, int light, int overlay, boolean flip, boolean isItem) {
        float nz;
        float nx = 0.0f;
        float ny = 0.0f;
        float f = nz = flip ? 1.0f : -1.0f;
        if (!flip) {
            Vector3f v3f1 = new Vector3f(0.0f, 0.0f, 0.0f);
            v3f1.mulTransposePosition((Matrix4fc)stack.last().pose());
            stack.translate(-v3f1.x(), -v3f1.y(), -v3f1.z());
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            stack.translate(v3f1.x() - (float)w, v3f1.y(), v3f1.z());
        }
        PoseStack.Pose pose = stack.last();
        vcons.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(flip ? 0.0f : 1.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, nx, ny, nz);
        vcons.addVertex(pose, 0.0f, (float)h, 0.0f).setColor(255, 255, 255, 255).setUv(flip ? 0.0f : 1.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, nx, ny, nz);
        vcons.addVertex(pose, (float)w, (float)h, 0.0f).setColor(255, 255, 255, 255).setUv(flip ? 1.0f : 0.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, nx, ny, nz);
        vcons.addVertex(pose, (float)w, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(flip ? 1.0f : 0.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, nx, ny, nz);
    }

    private static void renderWaveSimple(VertexConsumer vcons, PoseStack stack, float partialTicks, float w, float h, int light, int overlay, boolean flip) {
        Minecraft mc = Minecraft.getInstance();
        float sample = 1.0f;
        float freq = 0.3926991f;
        float coAmp = 0.5f / (w <= 0.01f ? 1.0f : w);
        int sz = Mth.ceil((float)(w * sample)) + 1;
        float phaseOffs = mc.level == null ? 0.0f : (float)(mc.level.getGameTime() % 16L) + partialTicks;
        float[] horizDisp = new float[sz];
        float sampleRec = 1.0f / sample;
        for (int i = 0; i < sz; ++i) {
            horizDisp[i] = Mth.sin((float)(freq * ((float)i * sampleRec - phaseOffs))) * coAmp * (float)i * sampleRec;
        }
        Vector3f[] normals = new Vector3f[sz];
        for (int i = 0; i < sz; ++i) {
            if (i == 0) {
                normals[i] = new Vector3f(sampleRec, 0.0f, i + 1 == sz ? 0.0f : -horizDisp[i]).normalize();
                continue;
            }
            if (i + 1 == sz) {
                normals[i] = new Vector3f(sampleRec, 0.0f, horizDisp[i]).normalize();
                continue;
            }
            Vector3f vec1 = new Vector3f(horizDisp[i - 1], 0.0f, -sampleRec);
            float len1 = vec1.length();
            Vector3f vec2 = new Vector3f(horizDisp[i + 1], 0.0f, sampleRec);
            float len2 = vec2.length();
            Vector3f vec3 = vec1.mul(len2).add((Vector3fc)vec2.mul(len1));
            if ((double)vec3.lengthSquared() <= 1.0E-4) {
                vec3 = new Vector3f(sampleRec, 0.0f, -horizDisp[i]);
            }
            if (!flip) {
                vec3.mul(-1.0f);
            }
            normals[i] = vec3.normalize();
        }
        if (!flip) {
            Vector3f v3f1 = new Vector3f(0.0f, 0.0f, 0.0f);
            v3f1.mulTransposePosition((Matrix4fc)stack.last().pose());
            stack.translate(-v3f1.x(), -v3f1.y(), -v3f1.z());
            stack.translate(v3f1.x() + w, v3f1.y(), v3f1.z());
        }
        PoseStack.Pose pose = stack.last();
        float f = sz <= 2 ? 1.0f : 1.0f / (float)(sz - 1);
        float ulen = w * f;
        for (int i = 0; i < sz - 1; ++i) {
            int index = flip ? i : sz - i - 1;
            int nextIndex = flip ? i + 1 : sz - i - 2;
            Vector3f n1 = normals[index];
            Vector3f n2 = normals[nextIndex];
            float u1 = flip ? 0.0f + (float)i * f : 1.0f - (float)i * f;
            float u2 = flip ? u1 + f : u1 - f;
            float w1 = flip ? ulen * (float)i : ulen * (float)(-i);
            float w2 = flip ? w1 + ulen : w1 - ulen;
            float z1 = horizDisp[index];
            float z2 = horizDisp[nextIndex];
            vcons.addVertex(pose, w1, 0.0f, z1).setColor(255, 255, 255, 255).setUv(u1, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, n1.x, n1.y, n1.z);
            vcons.addVertex(pose, w1, h, z1).setColor(255, 255, 255, 255).setUv(u1, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, n1.x, n1.y, n1.z);
            vcons.addVertex(pose, w2, h, z2).setColor(255, 255, 255, 255).setUv(u2, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, n2.x, n2.y, n2.z);
            vcons.addVertex(pose, w2, 0.0f, z2).setColor(255, 255, 255, 255).setUv(u2, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, n2.x, n2.y, n2.z);
        }
    }

    public static ResourceLocation getFlagLocation(ResourceLocation flagId, double distance) {
        Minecraft mc = Minecraft.getInstance();
        double blocksVisible = Math.tan((double)((Integer)mc.options.fov().get()).intValue() / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        Optional painting = ClientPaintingManager.getPainting((ResourceLocation)flagId);
        if (painting.isEmpty()) {
            return ClientPaintingManager.getImageIdentifier((ResourceLocation)BetsyRoss.DEFAULT_FLAG, (Painting.Size)Painting.Size.FULL);
        }
        double pixelDensity = blocksVisible * (double)((Painting)painting.get()).resolution() / (double)mc.getWindow().getHeight();
        Painting.Size size = pixelDensity > (double)Configs.CLIENT.thumbResolutionThreshold ? Painting.Size.THUMBNAIL : (pixelDensity > (double)Configs.CLIENT.eighthResolutionThreshold ? Painting.Size.EIGHTH : (pixelDensity > (double)Configs.CLIENT.quarterResolutionThreshold ? Painting.Size.QUARTER : (pixelDensity > (double)Configs.CLIENT.halfResolutionThreshold ? Painting.Size.HALF : Painting.Size.FULL)));
        return ClientPaintingManager.getImageIdentifier((ResourceLocation)flagId, (Painting.Size)size);
    }
}

