/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags.standards;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.BetsyRossClient;
import rbasamoyai.betsyross.content.BetsyRossDataComponents;
import rbasamoyai.betsyross.flags.flag_block.FlagAnimationDetail;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntityRenderer;
import rbasamoyai.betsyross.flags.standards.FlagStandardRenderer;

public class ArmorBannerRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Material STANDARD_FLAGPOLE = FlagStandardRenderer.STANDARD_FLAGPOLE;
    private final ModelPart flagpole;

    public ArmorBannerRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet models) {
        super(dispatcher, models);
        this.flagpole = models.bakeLayer(BetsyRossClient.ARMOR_FLAGPOLE);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack posestack, MultiBufferSource buffers, int light, int overlay) {
        Minecraft mc = Minecraft.getInstance();
        ResourceLocation flagId = (ResourceLocation)stack.getOrDefault(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG);
        BetsyRossClient.FlagRenderInfo renderInfo = BetsyRossClient.getFlagRenderInfo(flagId);
        int width = renderInfo.width();
        int height = renderInfo.height();
        posestack.pushPose();
        float pt = mc.getTimer().getGameTimeDeltaPartialTick(true);
        if (transform == ItemDisplayContext.GUI) {
            width = 1;
            height = 1;
            pt = 1.0f;
        } else {
            this.flagpole.render(posestack, STANDARD_FLAGPOLE.buffer(buffers, RenderType::entitySolid), light, overlay);
            posestack.translate(0.5, 2.0, 0.0);
        }
        float dir = transform == ItemDisplayContext.GUI ? 90.0f : 0.0f;
        posestack.translate(0.0, 1.0, 0.5);
        double distance = 0.0;
        FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, width, height, pt, dir, posestack, buffers, light, overlay, false, FlagAnimationDetail.NO_WAVE, true);
        FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, width, height, pt, dir, posestack, buffers, light, overlay, true, FlagAnimationDetail.NO_WAVE, true);
        posestack.popPose();
    }

    public static LayerDefinition defineArmorFlagpole() {
        MeshDefinition mesh = new MeshDefinition();
        mesh.getRoot().addOrReplaceChild("flagpole", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, 0.0f, 7.0f, 2.0f, 16.0f, 2.0f).texOffs(0, 0).addBox(7.0f, 16.0f, 7.0f, 2.0f, 16.0f, 2.0f).texOffs(0, 0).addBox(7.0f, 32.0f, 7.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

