/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags.standards;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.BetsyRossClient;
import rbasamoyai.betsyross.content.BetsyRossDataComponents;
import rbasamoyai.betsyross.flags.flag_block.FlagAnimationDetail;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntityRenderer;
import rbasamoyai.betsyross.flags.standards.FlagStandardRenderer;

public class BannerStandardRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Material STANDARD_FLAGPOLE = FlagStandardRenderer.STANDARD_FLAGPOLE;
    private final ModelPart flagpole;
    private final ModelPart bar;

    public BannerStandardRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet models) {
        super(dispatcher, models);
        this.flagpole = models.bakeLayer(BetsyRossClient.ITEM_FLAGPOLE);
        this.bar = models.bakeLayer(BetsyRossClient.ITEM_BANNER);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack posestack, MultiBufferSource buffers, int light, int overlay) {
        Minecraft mc = Minecraft.getInstance();
        ResourceLocation flagId = (ResourceLocation)stack.getOrDefault(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG);
        BetsyRossClient.FlagRenderInfo renderInfo = BetsyRossClient.getFlagRenderInfo(flagId);
        int width = renderInfo.width();
        int height = renderInfo.height();
        posestack.pushPose();
        float pt = mc.getTimer().getGameTimeDeltaPartialTick(true);
        if (transform == ItemDisplayContext.GUI) {
            width = 1;
            height = 1;
            pt = 1.0f;
            posestack.translate(0.0, 1.0, 0.5);
        } else {
            VertexConsumer vcons = STANDARD_FLAGPOLE.buffer(buffers, RenderType::entitySolid);
            this.flagpole.render(posestack, vcons, light, overlay);
            this.bar.render(posestack, vcons, light, overlay);
            posestack.translate(0.0, 1.0, 0.5);
            float freq = 0.0418879f;
            float phaseOffs = mc.level == null ? 0.0f : (float)(mc.level.getGameTime() % 150L) + pt;
            float c = Mth.sin((float)(-phaseOffs * freq));
            posestack.mulPose(Axis.YP.rotationDegrees(180.0f));
            posestack.translate((double)(-width) * 0.5 - 0.5, 3.125, 0.0625);
            Vector3f v3f = new Vector3f(0.0f, 0.0f, 0.0f);
            v3f.mulTransposePosition((Matrix4fc)posestack.last().pose());
            posestack.translate(-v3f.x(), -v3f.y(), -v3f.z());
            posestack.mulPose(Axis.XP.rotationDegrees(-5.0f * c * c));
            posestack.translate(v3f.x(), v3f.y(), v3f.z());
        }
        FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), 0.0, width, height, pt, 90.0f, posestack, buffers, light, overlay, false, FlagAnimationDetail.NO_WAVE, true);
        FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), 0.0, width, height, pt, 90.0f, posestack, buffers, light, overlay, true, FlagAnimationDetail.NO_WAVE, true);
        posestack.popPose();
    }

    public static LayerDefinition defineBannerBar() {
        MeshDefinition mesh = new MeshDefinition();
        mesh.getRoot().addOrReplaceChild("bar", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, 64.0f, 7.0f, 20.0f, 2.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

