/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags.standards;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.BetsyRossClient;
import rbasamoyai.betsyross.config.BetsyRossConfig;
import rbasamoyai.betsyross.content.BetsyRossDataComponents;
import rbasamoyai.betsyross.flags.flag_block.FlagAnimationDetail;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntityRenderer;

public class FlagStandardRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Material STANDARD_FLAGPOLE = new Material(TextureAtlas.LOCATION_BLOCKS, BetsyRoss.path("item/standard_flagpole"));
    private final ModelPart flagpole;

    public FlagStandardRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet models) {
        super(dispatcher, models);
        this.flagpole = models.bakeLayer(BetsyRossClient.ITEM_FLAGPOLE);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack posestack, MultiBufferSource buffers, int light, int overlay) {
        Minecraft mc = Minecraft.getInstance();
        ResourceLocation flagId = (ResourceLocation)stack.getOrDefault(BetsyRossDataComponents.FLAG_ID.get(), (Object)BetsyRoss.DEFAULT_FLAG);
        BetsyRossClient.FlagRenderInfo renderInfo = BetsyRossClient.getFlagRenderInfo(flagId);
        int width = renderInfo.width();
        int height = renderInfo.height();
        posestack.pushPose();
        FlagAnimationDetail detail = BetsyRossConfig.CLIENT.animationDetail;
        float pt = mc.getTimer().getGameTimeDeltaPartialTick(true);
        this.flagpole.render(posestack, STANDARD_FLAGPOLE.buffer(buffers, RenderType::entitySolid), light, overlay);
        posestack.translate(0.5, 3.0, 0.0);
        posestack.translate(0.0, 1.0, 0.5);
        FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), 0.0, width, height, pt, 0.0f, posestack, buffers, light, overlay, false, detail, true);
        FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), 0.0, width, height, pt, 0.0f, posestack, buffers, light, overlay, true, detail, true);
        posestack.popPose();
    }

    public static LayerDefinition defineFlagpole() {
        MeshDefinition mesh = new MeshDefinition();
        mesh.getRoot().addOrReplaceChild("flagpole", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, 0.0f, 7.0f, 2.0f, 16.0f, 2.0f).texOffs(0, 0).addBox(7.0f, 16.0f, 7.0f, 2.0f, 16.0f, 2.0f).texOffs(0, 0).addBox(7.0f, 32.0f, 7.0f, 2.0f, 16.0f, 2.0f).texOffs(0, 0).addBox(7.0f, 48.0f, 7.0f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

