/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.network.s2c;

import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockScreen;
import rbasamoyai.betsyross.network.BetsyRossPayload;

public record S2COpenFlagBlockScreenPayload(BlockPos pos, int minResolution, int maxResolution, boolean showOtherPlayerPaintings, int permissionLevel) implements BetsyRossPayload
{
    public static final CustomPacketPayload.Type<S2COpenFlagBlockScreenPayload> TYPE = new CustomPacketPayload.Type(BetsyRoss.path("open_flag_block_screen"));
    public static final StreamCodec<FriendlyByteBuf, S2COpenFlagBlockScreenPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, S2COpenFlagBlockScreenPayload::pos, (StreamCodec)ByteBufCodecs.VAR_INT, S2COpenFlagBlockScreenPayload::minResolution, (StreamCodec)ByteBufCodecs.VAR_INT, S2COpenFlagBlockScreenPayload::maxResolution, (StreamCodec)ByteBufCodecs.BOOL, S2COpenFlagBlockScreenPayload::showOtherPlayerPaintings, (StreamCodec)ByteBufCodecs.VAR_INT, S2COpenFlagBlockScreenPayload::permissionLevel, S2COpenFlagBlockScreenPayload::new);

    @Override
    public void handle(Player player, Executor exec) {
        exec.execute(() -> ScreenProxy.load(this, player));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static class ScreenProxy {
        private ScreenProxy() {
        }

        public static void load(S2COpenFlagBlockScreenPayload payload, Player player) {
            BlockEntity blockEntity = player.level().getBlockEntity(payload.pos);
            if (blockEntity instanceof FlagBlockEntity) {
                FlagBlockEntity flag = (FlagBlockEntity)blockEntity;
                Minecraft.getInstance().setScreen((Screen)new FlagBlockScreen(payload.pos, flag, payload.minResolution, payload.maxResolution, payload.showOtherPlayerPaintings, payload.permissionLevel));
            }
        }
    }
}

