/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.content.BetsyRossBlockEntities;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.content.BetsyRossItems;
import rbasamoyai.betsyross.flags.flag_block.DrapedFlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntityRenderer;
import rbasamoyai.betsyross.flags.standards.ArmorBannerRenderer;
import rbasamoyai.betsyross.flags.standards.BannerStandardRenderer;
import rbasamoyai.betsyross.flags.standards.FlagStandardRenderer;
import rbasamoyai.betsyross.forge.BetsyRossClientImpl;
import rbasamoyai.betsyross.network.BetsyRossNetwork;
import rbasamoyai.betsyross.network.CommonPacket;

public class BetsyRossClient {
    private static BlockEntityWithoutLevelRenderer FLAG_STANDARD_RENDERER;
    private static BlockEntityWithoutLevelRenderer BANNER_STANDARD_RENDERER;
    private static BlockEntityWithoutLevelRenderer ARMOR_BANNER_RENDERER;
    private static final Set<ModelLayerLocation> ALL_LAYERS;
    public static final ModelLayerLocation ITEM_FLAGPOLE;
    public static final ModelLayerLocation ITEM_BANNER;
    public static final ModelLayerLocation ARMOR_FLAGPOLE;
    public static final ResourceLocation SPECIAL_ARMOR_BANNER_MODEL;
    public static final ResourceLocation SPECIAL_BANNER_STANDARD_MODEL;
    public static final ResourceLocation SPECIAL_BANNER_STANDARD_RAISED_MODEL;
    public static final ResourceLocation SPECIAL_FLAG_STANDARD_MODEL;

    public static BlockEntityWithoutLevelRenderer getFlagStandardRenderer() {
        if (FLAG_STANDARD_RENDERER == null) {
            Minecraft mc = Minecraft.m_91087_();
            FLAG_STANDARD_RENDERER = new FlagStandardRenderer(mc.m_167982_(), mc.m_167973_());
        }
        return FLAG_STANDARD_RENDERER;
    }

    public static BlockEntityWithoutLevelRenderer getBannerStandardRenderer() {
        if (BANNER_STANDARD_RENDERER == null) {
            Minecraft mc = Minecraft.m_91087_();
            BANNER_STANDARD_RENDERER = new BannerStandardRenderer(mc.m_167982_(), mc.m_167973_());
        }
        return BANNER_STANDARD_RENDERER;
    }

    public static BlockEntityWithoutLevelRenderer getArmorBannerRenderer() {
        if (ARMOR_BANNER_RENDERER == null) {
            Minecraft mc = Minecraft.m_91087_();
            ARMOR_BANNER_RENDERER = new ArmorBannerRenderer(mc.m_167982_(), mc.m_167973_());
        }
        return ARMOR_BANNER_RENDERER;
    }

    private static ModelLayerLocation registerLayer(String id) {
        ModelLayerLocation loc = new ModelLayerLocation(BetsyRoss.path(id), "main");
        if (!ALL_LAYERS.add(loc)) {
            throw new IllegalStateException("Duplicate registration for " + loc);
        }
        return loc;
    }

    public static void init(BiConsumer<Block, RenderType> layerRegistration) {
        BetsyRossClient.registerItemProperty(BetsyRossItems.BANNER_STANDARD.get(), BetsyRoss.path("raised"), (stack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        layerRegistration.accept(BetsyRossBlocks.EMBROIDERY_TABLE_BLOCK.get(), RenderType.m_110463_());
    }

    public static void registerModels(Consumer<ResourceLocation> cons) {
        cons.accept(SPECIAL_ARMOR_BANNER_MODEL);
        cons.accept(SPECIAL_BANNER_STANDARD_MODEL);
        cons.accept(SPECIAL_BANNER_STANDARD_RAISED_MODEL);
        cons.accept(SPECIAL_FLAG_STANDARD_MODEL);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemProperty(Item item, ResourceLocation location, ItemPropertyFunction func) {
        void var2_2;
        void var1_1;
        BetsyRossClientImpl.registerItemProperty(item, (ResourceLocation)var1_1, (ItemPropertyFunction)var2_2);
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRenderers.m_173590_(BetsyRossBlockEntities.FLAG_BLOCK_ENTITY.get(), FlagBlockEntityRenderer::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> cons) {
        cons.accept(ITEM_FLAGPOLE, FlagStandardRenderer::defineFlagpole);
        cons.accept(ITEM_BANNER, BannerStandardRenderer::defineBannerBar);
        cons.accept(ARMOR_FLAGPOLE, ArmorBannerRenderer::defineArmorFlagpole);
    }

    public static void sendToServer(CommonPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            return;
        }
        BetsyRossNetwork.sendToServer(arg_0 -> ((ClientPacketListener)mc.m_91403_()).m_104955_(arg_0), packet);
    }

    public static boolean renderCustomItem(BlockEntityWithoutLevelRenderer original, ItemStack stack, ItemDisplayContext transform, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        if (stack.m_150930_((Item)BetsyRossItems.FLAG_STANDARD.get()) && original != BetsyRossClient.getFlagStandardRenderer()) {
            BetsyRossClient.getFlagStandardRenderer().m_108829_(stack, transform, poseStack, buffers, light, overlay);
            return true;
        }
        if (stack.m_150930_((Item)BetsyRossItems.BANNER_STANDARD.get()) && original != BetsyRossClient.getBannerStandardRenderer()) {
            BetsyRossClient.getBannerStandardRenderer().m_108829_(stack, transform, poseStack, buffers, light, overlay);
            return true;
        }
        if (stack.m_150930_((Item)BetsyRossItems.ARMOR_BANNER.get()) && original != BetsyRossClient.getArmorBannerRenderer()) {
            BetsyRossClient.getArmorBannerRenderer().m_108829_(stack, transform, poseStack, buffers, light, overlay);
            return true;
        }
        return false;
    }

    public static FlagRenderInfo getFlagRenderInfo(ResourceLocation location) {
        Painting painting = (Painting)ClientPaintingManager.getPaintings().get(location);
        if (painting == null) {
            painting = ClientPaintingManager.getPainting((ResourceLocation)BetsyRoss.DEFAULT_FLAG);
            location = BetsyRoss.DEFAULT_FLAG;
        }
        return new FlagRenderInfo(location, painting.width, painting.height);
    }

    public static AABB getFlagBlockEntityBox(FlagBlockEntity flag) {
        BlockState state = flag.m_58900_();
        BlockPos pos = flag.m_58899_();
        Painting painting = (Painting)ClientPaintingManager.getPaintings().get(flag.getFlagId());
        if (painting == null) {
            painting = ClientPaintingManager.getPainting((ResourceLocation)BetsyRoss.DEFAULT_FLAG);
        }
        int flagWidth = painting.width;
        int flagHeight = painting.height;
        if (state.m_60713_((Block)BetsyRossBlocks.FLAG_BLOCK.get())) {
            float dir = RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)FlagBlock.ROTATION)));
            float f1 = Mth.m_14031_((float)(dir * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(dir * ((float)Math.PI / 180)));
            return new AABB(pos).m_82363_((double)(f1 * (float)flagWidth), (double)flagHeight, (double)(f2 * (float)flagWidth)).m_82400_(1.0);
        }
        if (state.m_60713_((Block)BetsyRossBlocks.DRAPED_FLAG_BLOCK.get())) {
            Direction dir = (Direction)state.m_61143_((Property)DrapedFlagBlock.FACING);
            return new AABB(pos.m_121945_(dir.m_122424_()), pos.m_6625_(flagHeight).m_5484_(dir.m_122428_(), flagWidth)).m_82400_(1.0);
        }
        return new AABB(pos);
    }

    static {
        ALL_LAYERS = new HashSet<ModelLayerLocation>();
        ITEM_FLAGPOLE = BetsyRossClient.registerLayer("item_flagpole");
        ITEM_BANNER = BetsyRossClient.registerLayer("item_banner");
        ARMOR_FLAGPOLE = BetsyRossClient.registerLayer("armor_flagpole");
        SPECIAL_ARMOR_BANNER_MODEL = BetsyRoss.path("item/special_armor_banner");
        SPECIAL_BANNER_STANDARD_MODEL = BetsyRoss.path("item/special_banner_standard");
        SPECIAL_BANNER_STANDARD_RAISED_MODEL = BetsyRoss.path("item/special_banner_standard_raised");
        SPECIAL_FLAG_STANDARD_MODEL = BetsyRoss.path("item/special_flag_standard");
    }

    public record FlagRenderInfo(ResourceLocation location, int width, int height) {
    }
}

