/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.content;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.foundation.ObjectHolder;

public class BetsyRossBlockEntities {
    private static final Map<String, Supplier<? extends BlockEntityType<?>>> ENTRIES = new LinkedHashMap();
    public static final Supplier<BlockEntityType<FlagBlockEntity>> FLAG_BLOCK_ENTITY = BetsyRossBlockEntities.register("flag", () -> BlockEntityType.Builder.m_155273_(FlagBlockEntity::new, (Block[])new Block[]{BetsyRossBlocks.FLAG_BLOCK.get(), (Block)BetsyRossBlocks.DRAPED_FLAG_BLOCK.get()}).m_58966_(null));

    private static <T extends BlockEntity> Supplier<BlockEntityType<T>> register(String id, Supplier<BlockEntityType<T>> blockEntityType) {
        if (ENTRIES.containsKey(id)) {
            throw new IllegalStateException("Cannot register id '" + id + "' more than once");
        }
        ObjectHolder<BlockEntityType<T>> holder = new ObjectHolder<BlockEntityType<T>>(blockEntityType);
        ENTRIES.put(id, holder);
        return holder;
    }

    public static void registerAll(BiConsumer<ResourceLocation, BlockEntityType<?>> cons) {
        for (Map.Entry<String, Supplier<BlockEntityType<?>>> entry : ENTRIES.entrySet()) {
            cons.accept(BetsyRoss.path(entry.getKey()), entry.getValue().get());
        }
    }
}

