/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.flags.flag_block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import immersive_paintings.Config;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.betsyross.BetsyRossClient;
import rbasamoyai.betsyross.config.BetsyRossConfig;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.flags.flag_block.DrapedFlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagAnimationDetail;
import rbasamoyai.betsyross.flags.flag_block.FlagBlock;
import rbasamoyai.betsyross.flags.flag_block.FlagBlockEntity;
import rbasamoyai.betsyross.remix.CulledRenderBBBlockEntity;
import rbasamoyai.betsyross.remix.FrustumCache;

public class FlagBlockEntityRenderer
implements BlockEntityRenderer<FlagBlockEntity> {
    private final BlockRenderDispatcher brd;

    public FlagBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.brd = ctx.m_173584_();
    }

    public void render(FlagBlockEntity flag, float partialTicks, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        CulledRenderBBBlockEntity culled;
        if (flag instanceof CulledRenderBBBlockEntity && !FrustumCache.isVisible((culled = (CulledRenderBBBlockEntity)((Object)flag)).getRenderBox())) {
            return;
        }
        ResourceLocation flagId = flag.getFlagId();
        BetsyRossClient.FlagRenderInfo renderInfo = BetsyRossClient.getFlagRenderInfo(flagId);
        int w = renderInfo.width();
        int h = renderInfo.height();
        BlockState state = flag.m_58900_();
        Minecraft mc = Minecraft.m_91087_();
        double distance = mc.f_91074_ == null ? 0.0 : Math.sqrt(mc.f_91074_.m_20238_(Vec3.m_82512_((Vec3i)flag.m_58899_())));
        stack.m_85836_();
        if (state.m_60713_((Block)BetsyRossBlocks.FLAG_BLOCK.get())) {
            float dir = RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)FlagBlock.ROTATION)));
            FlagAnimationDetail detail = (FlagAnimationDetail)((Object)BetsyRossConfig.CLIENT.animationDetail.get());
            stack.m_85836_();
            stack.m_85837_(0.5, (double)h, 0.5);
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, dir, stack, buffers, packedLight, packedOverlay, false, detail, false);
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, dir, stack, buffers, packedLight, packedOverlay, true, detail, false);
            stack.m_85849_();
            BlockState flagpole = flag.getFlagPole();
            if (flagpole != null) {
                this.brd.m_110912_(flagpole, stack, buffers, packedLight, packedOverlay);
            }
        } else if (state.m_60713_((Block)BetsyRossBlocks.DRAPED_FLAG_BLOCK.get())) {
            Direction dir = (Direction)state.m_61143_((Property)DrapedFlagBlock.FACING);
            Direction dir1 = dir.m_122434_() == Direction.Axis.X ? dir.m_122428_() : dir.m_122427_();
            float f = dir1.m_122435_();
            stack.m_252880_(0.0f, 1.0f, 0.0f);
            if (dir == Direction.WEST || dir == Direction.NORTH) {
                stack.m_252880_(1.0f, 0.0f, 0.0f);
            }
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                stack.m_252880_(0.0f, 0.0f, 1.0f);
            }
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, f, stack, buffers, packedLight, packedOverlay, false, FlagAnimationDetail.NO_WAVE, false);
            FlagBlockEntityRenderer.renderFullTexture(renderInfo.location(), distance, w, h, partialTicks, f, stack, buffers, packedLight, packedOverlay, true, FlagAnimationDetail.NO_WAVE, false);
        }
        stack.m_85849_();
    }

    public static void renderFullTexture(ResourceLocation flagId, double distance, int width, int height, float partialTicks, float dir, PoseStack stack, MultiBufferSource buffers, int packedLight, int packedOverlay, boolean flip, FlagAnimationDetail detail, boolean isItem) {
        if (width <= 0 || height <= 0) {
            return;
        }
        stack.m_85836_();
        Vector3f v3f = new Vector3f(0.0f, 0.0f, 0.0f);
        v3f.mulTransposePosition((Matrix4fc)stack.m_85850_().m_252922_());
        stack.m_252880_(-v3f.x(), -v3f.y(), -v3f.z());
        stack.m_252781_(Axis.f_252436_.m_252977_(dir - 90.0f));
        stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        stack.m_252880_(v3f.x(), v3f.y(), v3f.z());
        stack.m_85837_(0.0, 0.0, flip ? -0.01 : 0.01);
        VertexConsumer vcons = buffers.m_6299_(FlagBlockEntityRenderer.getFlagBuffer(flagId, distance));
        switch (detail) {
            case NO_WAVE: {
                FlagBlockEntityRenderer.renderSimple(vcons, stack, width, height, packedLight, packedOverlay, flip, isItem);
                break;
            }
            case WAVE: {
                FlagBlockEntityRenderer.renderWaveSimple(vcons, stack, partialTicks, width, height, packedLight, packedOverlay, flip);
            }
        }
        stack.m_85849_();
    }

    private static void renderSimple(VertexConsumer vcons, PoseStack stack, int w, int h, int light, int overlay, boolean flip, boolean isItem) {
        float nz;
        float nx = 0.0f;
        float ny = 0.0f;
        float f = nz = flip ? 1.0f : -1.0f;
        if (!flip) {
            Vector3f v3f1 = new Vector3f(0.0f, 0.0f, 0.0f);
            v3f1.mulTransposePosition((Matrix4fc)stack.m_85850_().m_252922_());
            stack.m_252880_(-v3f1.x(), -v3f1.y(), -v3f1.z());
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            stack.m_252880_(v3f1.x() - (float)w, v3f1.y(), v3f1.z());
        }
        Matrix4f pose = stack.m_85850_().m_252922_();
        Matrix3f normal = stack.m_85850_().m_252943_();
        vcons.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(flip ? 0.0f : 1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        vcons.m_252986_(pose, 0.0f, (float)h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(flip ? 0.0f : 1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        vcons.m_252986_(pose, (float)w, (float)h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(flip ? 1.0f : 0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        vcons.m_252986_(pose, (float)w, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(flip ? 1.0f : 0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
    }

    private static void renderWaveSimple(VertexConsumer vcons, PoseStack stack, float partialTicks, float w, float h, int light, int overlay, boolean flip) {
        Minecraft mc = Minecraft.m_91087_();
        float sample = 1.0f;
        float freq = 0.3926991f;
        float coAmp = 0.5f / (w <= 0.01f ? 1.0f : w);
        int sz = Mth.m_14167_((float)(w * sample)) + 1;
        float phaseOffs = mc.f_91073_ == null ? 0.0f : (float)(mc.f_91073_.m_46467_() % 16L) + partialTicks;
        float[] horizDisp = new float[sz];
        float sampleRec = 1.0f / sample;
        for (int i = 0; i < sz; ++i) {
            horizDisp[i] = Mth.m_14031_((float)(freq * ((float)i * sampleRec - phaseOffs))) * coAmp * (float)i * sampleRec;
        }
        Vector3f[] normals = new Vector3f[sz];
        for (int i = 0; i < sz; ++i) {
            if (i == 0) {
                normals[i] = new Vector3f(sampleRec, 0.0f, i + 1 == sz ? 0.0f : -horizDisp[i]).normalize();
                continue;
            }
            if (i + 1 == sz) {
                normals[i] = new Vector3f(sampleRec, 0.0f, horizDisp[i]).normalize();
                continue;
            }
            Vector3f vec1 = new Vector3f(horizDisp[i - 1], 0.0f, -sampleRec);
            float len1 = vec1.length();
            Vector3f vec2 = new Vector3f(horizDisp[i + 1], 0.0f, sampleRec);
            float len2 = vec2.length();
            Vector3f vec3 = vec1.mul(len2).add((Vector3fc)vec2.mul(len1));
            if ((double)vec3.lengthSquared() <= 1.0E-4) {
                vec3 = new Vector3f(sampleRec, 0.0f, -horizDisp[i]);
            }
            if (!flip) {
                vec3.mul(-1.0f);
            }
            normals[i] = vec3.normalize();
        }
        if (!flip) {
            Vector3f v3f1 = new Vector3f(0.0f, 0.0f, 0.0f);
            v3f1.mulTransposePosition((Matrix4fc)stack.m_85850_().m_252922_());
            stack.m_252880_(-v3f1.x(), -v3f1.y(), -v3f1.z());
            stack.m_252880_(v3f1.x() + w, v3f1.y(), v3f1.z());
        }
        Matrix4f pose = stack.m_85850_().m_252922_();
        Matrix3f normal = stack.m_85850_().m_252943_();
        float f = sz <= 2 ? 1.0f : 1.0f / (float)(sz - 1);
        float ulen = w * f;
        for (int i = 0; i < sz - 1; ++i) {
            int index = flip ? i : sz - i - 1;
            int nextIndex = flip ? i + 1 : sz - i - 2;
            Vector3f n1 = normals[index];
            Vector3f n2 = normals[nextIndex];
            float u1 = flip ? 0.0f + (float)i * f : 1.0f - (float)i * f;
            float u2 = flip ? u1 + f : u1 - f;
            float w1 = flip ? ulen * (float)i : ulen * (float)(-i);
            float w2 = flip ? w1 + ulen : w1 - ulen;
            float z1 = horizDisp[index];
            float z2 = horizDisp[nextIndex];
            vcons.m_252986_(pose, w1, 0.0f, z1).m_6122_(255, 255, 255, 255).m_7421_(u1, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, n1.x, n1.y, n1.z).m_5752_();
            vcons.m_252986_(pose, w1, h, z1).m_6122_(255, 255, 255, 255).m_7421_(u1, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, n1.x, n1.y, n1.z).m_5752_();
            vcons.m_252986_(pose, w2, h, z2).m_6122_(255, 255, 255, 255).m_7421_(u2, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, n2.x, n2.y, n2.z).m_5752_();
            vcons.m_252986_(pose, w2, 0.0f, z2).m_6122_(255, 255, 255, 255).m_7421_(u2, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, n2.x, n2.y, n2.z).m_5752_();
        }
    }

    public static RenderType getFlagBuffer(ResourceLocation flagId, double distance) {
        int resolution;
        Minecraft mc = Minecraft.m_91087_();
        Config config = Config.getInstance();
        double blocksVisible = Math.tan((double)((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue() / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        double pixelDensity = blocksVisible * (double)(resolution = ClientPaintingManager.getPainting((ResourceLocation)flagId).resolution) / (double)mc.m_91268_().m_85442_();
        Painting.Type type = pixelDensity > (double)config.eighthResolutionThreshold ? Painting.Type.EIGHTH : (pixelDensity > (double)config.quarterResolutionThreshold ? Painting.Type.QUARTER : (pixelDensity > (double)config.halfResolutionThreshold ? Painting.Type.HALF : Painting.Type.FULL));
        return RenderType.m_110470_((ResourceLocation)ClientPaintingManager.getPaintingTexture((ResourceLocation)flagId, (Painting.Type)type).textureIdentifier);
    }
}

