/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.betsyross.forge;

import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import rbasamoyai.betsyross.BetsyRoss;
import rbasamoyai.betsyross.BetsyRossCommonEvents;
import rbasamoyai.betsyross.config.BetsyRossConfig;
import rbasamoyai.betsyross.content.BetsyRossBlockEntities;
import rbasamoyai.betsyross.content.BetsyRossBlocks;
import rbasamoyai.betsyross.content.BetsyRossCreativeModeTab;
import rbasamoyai.betsyross.content.BetsyRossItems;
import rbasamoyai.betsyross.content.BetsyRossStats;
import rbasamoyai.betsyross.forge.BetsyRossClientForge;
import rbasamoyai.betsyross.network.BetsyRossNetwork;

@Mod(value="betsyross")
public class BetsyRossForge {
    public BetsyRossForge() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        BetsyRoss.init();
        modBus.addListener(this::onRegister);
        modBus.addListener(this::onCommonSetup);
        forgeBus.addListener(this::onPlayerLogin);
        BetsyRossConfig.init((arg_0, arg_1) -> ((ModLoadingContext)ModLoadingContext.get()).registerConfig(arg_0, arg_1));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BetsyRossClientForge.onCtor(modBus, forgeBus));
    }

    private void onRegister(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256747_) {
            BetsyRossBlocks.registerAll(BetsyRossForge.registryConsumer(Registries.f_256747_, event));
        } else if (event.getRegistryKey() == Registries.f_256913_) {
            BetsyRossItems.registerAll(BetsyRossForge.registryConsumer(Registries.f_256913_, event));
        } else if (event.getRegistryKey() == Registries.f_256922_) {
            BetsyRossBlockEntities.registerAll(BetsyRossForge.registryConsumer(Registries.f_256922_, event));
        } else if (event.getRegistryKey() == Registries.f_279569_) {
            BetsyRossCreativeModeTab.create(BetsyRossForge.registryConsumer(Registries.f_279569_, event));
        } else if (event.getRegistryKey() == Registries.f_256887_) {
            BetsyRossStats.registerAll(BetsyRossForge.registryConsumer(Registries.f_256887_, event));
        }
    }

    private static <T> BiConsumer<ResourceLocation, T> registryConsumer(ResourceKey<? extends Registry<T>> key, RegisterEvent event) {
        return (loc, block) -> event.register(key, loc, () -> block);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BetsyRossNetwork.init();
            BetsyRossStats.activateAllStats();
        });
    }

    private void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            BetsyRossCommonEvents.onPlayerLogin(splayer);
        }
    }
}

