/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.common;

import com.google.gson.Gson;
import dev.vanutp.tgbridge.common.ILogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003J\r\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0003R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016RT\u0010\u0019\u001aB\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00060\u0006 \u0018* \u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\r8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\f\u0010 \u00a8\u0006!"}, d2={"Ldev/vanutp/tgbridge/common/MuteService;", "", "<init>", "()V", "Ljava/util/UUID;", "uuid", "", "mute", "(Ljava/util/UUID;)Z", "unmute", "isMuted", "Ldev/vanutp/tgbridge/common/ILogger;", "logger", "Ljava/nio/file/Path;", "configPath", "", "init", "(Ldev/vanutp/tgbridge/common/ILogger;Ljava/nio/file/Path;)V", "saveAsync", "shutdown", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "mutedUsers", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Ljava/util/concurrent/ExecutorService;", "executor", "Ljava/util/concurrent/ExecutorService;", "filePath", "Ljava/nio/file/Path;", "Ldev/vanutp/tgbridge/common/ILogger;", "tgbridge-common"})
public final class MuteService {
    @NotNull
    public static final MuteService INSTANCE = new MuteService();
    @NotNull
    private static final Gson gson = new Gson();
    private static final ConcurrentHashMap.KeySetView<UUID, Boolean> mutedUsers = ConcurrentHashMap.newKeySet();
    @NotNull
    private static final ExecutorService executor;
    private static Path filePath;
    private static ILogger logger;

    private MuteService() {
    }

    public final boolean mute(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (mutedUsers.add(uuid)) {
            this.saveAsync();
            return true;
        }
        return false;
    }

    public final boolean unmute(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (mutedUsers.remove(uuid)) {
            this.saveAsync();
            return true;
        }
        return false;
    }

    public final boolean isMuted(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return mutedUsers.contains(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(@NotNull ILogger logger, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        MuteService.logger = logger;
        filePath = configPath.resolve("muted_users.json");
        Path path = filePath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
            path = null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Path path2 = filePath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
                path2 = null;
            }
            Closeable closeable = Files.newBufferedReader(path2);
            Throwable throwable = null;
            try {
                Object[] objectArray;
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                if ((UUID[])gson.fromJson((Reader)reader, UUID[].class) == null) {
                    return;
                }
                Object[] loaded = objectArray;
                mutedUsers.clear();
                ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = mutedUsers;
                Intrinsics.checkNotNullExpressionValue(keySetView, (String)"mutedUsers");
                boolean bl2 = CollectionsKt.addAll((Collection)keySetView, (Object[])loaded);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            logger.error("Failed to load muted users: " + e.getMessage(), e);
        }
    }

    private final void saveAsync() {
        ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = mutedUsers;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"mutedUsers");
        Set snapshot = CollectionsKt.toSet((Iterable)keySetView);
        executor.submit(() -> MuteService.saveAsync$lambda$2(snapshot));
    }

    public final void shutdown() {
        executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveAsync$lambda$2(Set $snapshot) {
        try {
            Path path = filePath;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
                path = null;
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path path2 = filePath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
                path2 = null;
            }
            Closeable closeable = Files.newBufferedWriter(path2, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                gson.toJson((Object)$snapshot, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            ILogger iLogger = logger;
            if (iLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                iLogger = null;
            }
            iLogger.error("Failed to save muted users: " + e.getMessage(), e);
        }
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        executor = executorService;
    }
}

