/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.kaml;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.kaml.Location;
import tgbridge.shaded.kaml.YamlPathSegment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\fJ\u001d\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0014J\u001d\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0015\u0010\u0019\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\fJ\u0017\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J \u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u001a\u0010%\u001a\u00020$2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\rH\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b)\u0010\u001eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b+\u0010 R\u0017\u0010,\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Ltgbridge/shaded/kaml/YamlPath;", "", "", "Ltgbridge/shaded/kaml/YamlPathSegment;", "segments", "<init>", "(Ljava/util/List;)V", "", "([Lcom/charleskorn/kaml/YamlPathSegment;)V", "Ltgbridge/shaded/kaml/Location;", "location", "withError", "(Ltgbridge/shaded/kaml/Location;)Ltgbridge/shaded/kaml/YamlPath;", "", "index", "withListEntry", "(ILtgbridge/shaded/kaml/Location;)Ltgbridge/shaded/kaml/YamlPath;", "", "key", "withMapElementKey", "(Ljava/lang/String;Ltgbridge/shaded/kaml/Location;)Ltgbridge/shaded/kaml/YamlPath;", "withMapElementValue", "name", "withAliasReference", "withAliasDefinition", "withMerge", "segment", "withSegment", "(Ltgbridge/shaded/kaml/YamlPathSegment;)Ltgbridge/shaded/kaml/YamlPath;", "toHumanReadableString", "()Ljava/lang/String;", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Ltgbridge/shaded/kaml/YamlPath;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "Ljava/util/List;", "getSegments", "endLocation", "Ltgbridge/shaded/kaml/Location;", "getEndLocation", "()Lcom/charleskorn/kaml/Location;", "Companion", "kaml"})
public final class YamlPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<YamlPathSegment> segments;
    @NotNull
    private final Location endLocation;
    @NotNull
    private static final YamlPath root;

    public YamlPath(@NotNull List<? extends YamlPathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
        if (this.segments.isEmpty()) {
            throw new IllegalArgumentException("Path must contain at least one segment.");
        }
        if (!(CollectionsKt.first(this.segments) instanceof YamlPathSegment.Root) && !(CollectionsKt.first(this.segments) instanceof YamlPathSegment.AliasDefinition)) {
            throw new IllegalArgumentException("First element of path must be root segment or alias definition.");
        }
        if (CollectionsKt.drop((Iterable)this.segments, (int)1).contains(YamlPathSegment.Root.INSTANCE)) {
            throw new IllegalArgumentException("Root segment can only be first element of path.");
        }
        this.endLocation = ((YamlPathSegment)CollectionsKt.last(this.segments)).getLocation();
    }

    @NotNull
    public final List<YamlPathSegment> getSegments() {
        return this.segments;
    }

    public YamlPath(YamlPathSegment ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        this(ArraysKt.toList((Object[])segments));
    }

    @NotNull
    public final Location getEndLocation() {
        return this.endLocation;
    }

    @NotNull
    public final YamlPath withError(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.Error(location));
    }

    @NotNull
    public final YamlPath withListEntry(int index, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.ListEntry(index, location));
    }

    @NotNull
    public final YamlPath withMapElementKey(@NotNull String key, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.MapElementKey(key, location));
    }

    @NotNull
    public final YamlPath withMapElementValue(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.MapElementValue(location));
    }

    @NotNull
    public final YamlPath withAliasReference(@NotNull String name, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.AliasReference(name, location));
    }

    @NotNull
    public final YamlPath withAliasDefinition(@NotNull String name, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.AliasDefinition(name, location));
    }

    @NotNull
    public final YamlPath withMerge(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.withSegment(new YamlPathSegment.Merge(location));
    }

    private final YamlPath withSegment(YamlPathSegment segment) {
        return new YamlPath(CollectionsKt.plus((Collection)this.segments, (Object)segment));
    }

    @NotNull
    public final String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        int nextSegmentIndex = 1;
        while (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments)) {
            StringBuilder stringBuilder;
            int segmentIndex;
            YamlPathSegment segment;
            if ((segment = this.segments.get(segmentIndex = nextSegmentIndex++)) instanceof YamlPathSegment.ListEntry) {
                builder.append('[');
                builder.append(((YamlPathSegment.ListEntry)segment).getIndex());
                stringBuilder = builder.append(']');
                continue;
            }
            if (segment instanceof YamlPathSegment.MapElementKey) {
                if (((CharSequence)builder).length() > 0) {
                    builder.append('.');
                }
                stringBuilder = builder.append(((YamlPathSegment.MapElementKey)segment).getKey());
                continue;
            }
            if (segment instanceof YamlPathSegment.AliasReference) {
                builder.append("->&");
                stringBuilder = builder.append(((YamlPathSegment.AliasReference)segment).getName());
                continue;
            }
            if (segment instanceof YamlPathSegment.Merge) {
                builder.append(">>(merged");
                if (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments) && this.segments.get(nextSegmentIndex) instanceof YamlPathSegment.ListEntry) {
                    builder.append(" entry ");
                    YamlPathSegment yamlPathSegment = this.segments.get(nextSegmentIndex);
                    Intrinsics.checkNotNull((Object)yamlPathSegment, (String)"null cannot be cast to non-null type com.charleskorn.kaml.YamlPathSegment.ListEntry");
                    builder.append(((YamlPathSegment.ListEntry)yamlPathSegment).getIndex());
                    ++nextSegmentIndex;
                }
                if (nextSegmentIndex <= CollectionsKt.getLastIndex(this.segments) && this.segments.get(nextSegmentIndex) instanceof YamlPathSegment.AliasReference) {
                    builder.append(" &");
                    YamlPathSegment yamlPathSegment = this.segments.get(nextSegmentIndex);
                    Intrinsics.checkNotNull((Object)yamlPathSegment, (String)"null cannot be cast to non-null type com.charleskorn.kaml.YamlPathSegment.AliasReference");
                    builder.append(((YamlPathSegment.AliasReference)yamlPathSegment).getName());
                    ++nextSegmentIndex;
                }
                stringBuilder = builder.append(")");
                continue;
            }
            if (segment instanceof YamlPathSegment.Root || segment instanceof YamlPathSegment.Error || segment instanceof YamlPathSegment.MapElementValue || segment instanceof YamlPathSegment.AliasDefinition) {
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (((CharSequence)builder).length() > 0) {
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "<root>";
    }

    @NotNull
    public final List<YamlPathSegment> component1() {
        return this.segments;
    }

    @NotNull
    public final YamlPath copy(@NotNull List<? extends YamlPathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        return new YamlPath(segments);
    }

    public static /* synthetic */ YamlPath copy$default(YamlPath yamlPath, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = yamlPath.segments;
        }
        return yamlPath.copy(list);
    }

    @NotNull
    public String toString() {
        return "YamlPath(segments=" + this.segments + ')';
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YamlPath)) {
            return false;
        }
        YamlPath yamlPath = (YamlPath)other;
        return Intrinsics.areEqual(this.segments, yamlPath.segments);
    }

    static {
        YamlPathSegment[] yamlPathSegmentArray = new YamlPathSegment[]{YamlPathSegment.Root.INSTANCE};
        root = new YamlPath(yamlPathSegmentArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ltgbridge/shaded/kaml/YamlPath$Companion;", "", "<init>", "()V", "", "name", "Ltgbridge/shaded/kaml/Location;", "location", "Ltgbridge/shaded/kaml/YamlPath;", "forAliasDefinition", "(Ljava/lang/String;Ltgbridge/shaded/kaml/Location;)Ltgbridge/shaded/kaml/YamlPath;", "root", "Ltgbridge/shaded/kaml/YamlPath;", "getRoot", "()Lcom/charleskorn/kaml/YamlPath;", "kaml"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final YamlPath getRoot() {
            return root;
        }

        @NotNull
        public final YamlPath forAliasDefinition(@NotNull String name, @NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            YamlPathSegment[] yamlPathSegmentArray = new YamlPathSegment[]{new YamlPathSegment.AliasDefinition(name, location)};
            return new YamlPath(yamlPathSegmentArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

