/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.net.thauvin.erik.urlencoder;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.net.thauvin.erik.urlencoder.Character;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u0012*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\u0012*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u001b\u0010\u0019\u001a\u00020\u0010*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u001c\u001a\u00020\u0006*\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Ltgbridge/shaded/net/thauvin/erik/urlencoder/UrlEncoderUtil;", "", "<init>", "()V", "", "source", "", "plusToSpace", "decode", "(Ljava/lang/String;Z)Ljava/lang/String;", "allow", "spaceToPlus", "encode", "(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "ch", "", "appendEncodedByte", "(Ljava/lang/StringBuilder;I)V", "digit", "appendEncodedDigit", "", "index", "codePointAt", "(Ljava/lang/CharSequence;I)I", "", "isUnreserved", "(C)Z", "", "hexDigits", "[C", "", "unreservedChars", "[Z", "urlencoder-lib"})
@SourceDebugExtension(value={"SMAP\nUrlEncoderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlEncoderUtil.kt\nnet/thauvin/erik/urlencoder/UrlEncoderUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class UrlEncoderUtil {
    @NotNull
    public static final UrlEncoderUtil INSTANCE;
    @NotNull
    private static final char[] hexDigits;
    @NotNull
    private static final boolean[] unreservedChars;

    private UrlEncoderUtil() {
    }

    private final boolean isUnreserved(char $this$isUnreserved) {
        return Intrinsics.compare((int)$this$isUnreserved, (int)122) <= 0 && unreservedChars[$this$isUnreserved];
    }

    private final void appendEncodedDigit(StringBuilder $this$appendEncodedDigit, int digit) {
        $this$appendEncodedDigit.append(hexDigits[digit & 0xF]);
    }

    private final void appendEncodedByte(StringBuilder $this$appendEncodedByte, int ch) {
        $this$appendEncodedByte.append("%");
        this.appendEncodedDigit($this$appendEncodedByte, ch >> 4);
        this.appendEncodedDigit($this$appendEncodedByte, ch);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String decode(@NotNull String source2, boolean plusToSpace) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        if (((CharSequence)source2).length() == 0) {
            return source2;
        }
        int length = source2.length();
        StringBuilder out = new StringBuilder(length);
        byte[] bytesBuffer = null;
        int bytesPos = 0;
        int i = 0;
        boolean started = false;
        while (i < length) {
            char ch = source2.charAt(i);
            if (ch == '%') {
                if (!started) {
                    out.append(source2, 0, i);
                    started = true;
                }
                if (bytesBuffer == null) {
                    bytesBuffer = new byte[(length - i) / 3];
                }
                if (!(length >= ++i + 2)) {
                    boolean bl = false;
                    String string2 = "Incomplete trailing escape (" + ch + ") pattern";
                    throw new IllegalArgumentException(string2.toString());
                }
                try {
                    String string3 = source2.substring(i, i + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    int v = Integer.parseInt(string3, CharsKt.checkRadix((int)16));
                    if (!(0 <= v ? v < 256 : false)) {
                        boolean bl = false;
                        String string4 = "Illegal escape value";
                        throw new IllegalArgumentException(string4.toString());
                    }
                    bytesBuffer[bytesPos++] = (byte)v;
                    i += 2;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal characters in escape sequence: " + e + ".message", e);
                }
            }
            if (bytesBuffer != null) {
                out.append(StringsKt.decodeToString$default(bytesBuffer, (int)0, (int)bytesPos, (boolean)false, (int)4, null));
                started = true;
                bytesBuffer = null;
                bytesPos = 0;
            }
            if (plusToSpace && ch == '+') {
                if (!started) {
                    out.append(source2, 0, i);
                    started = true;
                }
                out.append(" ");
            } else if (started) {
                out.append(ch);
            }
            ++i;
        }
        if (bytesBuffer != null) {
            out.append(StringsKt.decodeToString$default(bytesBuffer, (int)0, (int)bytesPos, (boolean)false, (int)4, null));
        }
        if (!started) {
            string = source2;
        } else {
            String string5 = out.toString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"out.toString()");
        }
        return string;
    }

    public static /* synthetic */ String decode$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlEncoderUtil.decode(string, bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String encode(@NotNull String source2, @NotNull String allow, boolean spaceToPlus) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)allow, (String)"allow");
        if (((CharSequence)source2).length() == 0) {
            return source2;
        }
        StringBuilder out = null;
        int i = 0;
        while (i < source2.length()) {
            char ch = source2.charAt(i);
            if (INSTANCE.isUnreserved(ch) || StringsKt.contains$default((CharSequence)allow, (char)ch, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = out;
                if (stringBuilder != null) {
                    stringBuilder.append(ch);
                }
                ++i;
                continue;
            }
            if (out == null) {
                out = new StringBuilder(source2.length());
                out.append(source2, 0, i);
            }
            int cp = INSTANCE.codePointAt(source2, i);
            if (cp < 128) {
                if (spaceToPlus && ch == ' ') {
                    out.append('+');
                } else {
                    INSTANCE.appendEncodedByte(out, cp);
                }
                ++i;
                continue;
            }
            if (Character.INSTANCE.isBmpCodePoint$urlencoder_lib(cp)) {
                for (byte b : StringsKt.encodeToByteArray((String)String.valueOf(ch))) {
                    INSTANCE.appendEncodedByte(out, b);
                }
                ++i;
                continue;
            }
            if (!Character.INSTANCE.isSupplementaryCodePoint$urlencoder_lib(cp)) continue;
            char high = Character.INSTANCE.highSurrogateOf$urlencoder_lib(cp);
            char low = Character.INSTANCE.lowSurrogateOf$urlencoder_lib(cp);
            char[] cArray = new char[]{high, low};
            for (byte b : StringsKt.encodeToByteArray((String)StringsKt.concatToString((char[])cArray))) {
                INSTANCE.appendEncodedByte(out, b);
            }
            i += 2;
        }
        StringBuilder stringBuilder = out;
        String string = stringBuilder != null ? stringBuilder.toString() : null;
        if (string == null) {
            string = source2;
        }
        return string;
    }

    public static /* synthetic */ String encode$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return UrlEncoderUtil.encode(string, string2, bl);
    }

    private final int codePointAt(CharSequence $this$codePointAt, int index) {
        if (!(0 <= index ? index < $this$codePointAt.length() : false)) {
            throw new IndexOutOfBoundsException("index " + index + " was not in range " + StringsKt.getIndices((CharSequence)$this$codePointAt));
        }
        char firstChar = $this$codePointAt.charAt(index);
        if (java.lang.Character.isHighSurrogate(firstChar)) {
            java.lang.Character nextChar;
            java.lang.Character c = nextChar = StringsKt.getOrNull((CharSequence)$this$codePointAt, (int)(index + 1));
            boolean bl = c != null ? java.lang.Character.isLowSurrogate(c.charValue()) : false;
            if (bl) {
                return Character.INSTANCE.toCodePoint$urlencoder_lib(firstChar, nextChar.charValue());
            }
        }
        return firstChar;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String decode(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return UrlEncoderUtil.decode$default(source2, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String encode(@NotNull String source2, @NotNull String allow) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)allow, (String)"allow");
        return UrlEncoderUtil.encode$default(source2, allow, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String encode(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return UrlEncoderUtil.encode$default(source2, null, false, 6, null);
    }

    static {
        int c;
        boolean[] blArray;
        INSTANCE = new UrlEncoderUtil();
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        hexDigits = cArray;
        boolean[] $this$unreservedChars_u24lambda_u240 = blArray = new boolean[123];
        boolean bl = false;
        $this$unreservedChars_u24lambda_u240[45] = true;
        $this$unreservedChars_u24lambda_u240[46] = true;
        $this$unreservedChars_u24lambda_u240[95] = true;
        for (c = 48; c < 58; c = (int)((char)(c + 1))) {
            $this$unreservedChars_u24lambda_u240[c] = true;
        }
        for (c = 65; c < 91; c = (int)((char)(c + 1))) {
            $this$unreservedChars_u24lambda_u240[c] = true;
        }
        for (c = 97; c < 123; c = (int)((char)(c + 1))) {
            $this$unreservedChars_u24lambda_u240[c] = true;
        }
        unreservedChars = blArray;
    }
}

