/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.okhttp3.CipherSuite;
import tgbridge.shaded.okhttp3.Handshake;
import tgbridge.shaded.okhttp3.Headers;
import tgbridge.shaded.okhttp3.HttpUrl;
import tgbridge.shaded.okhttp3.MediaType;
import tgbridge.shaded.okhttp3.Protocol;
import tgbridge.shaded.okhttp3.Request;
import tgbridge.shaded.okhttp3.Response;
import tgbridge.shaded.okhttp3.ResponseBody;
import tgbridge.shaded.okhttp3.TlsVersion;
import tgbridge.shaded.okhttp3.internal.Util;
import tgbridge.shaded.okhttp3.internal.cache.CacheRequest;
import tgbridge.shaded.okhttp3.internal.cache.CacheStrategy;
import tgbridge.shaded.okhttp3.internal.cache.DiskLruCache;
import tgbridge.shaded.okhttp3.internal.concurrent.TaskRunner;
import tgbridge.shaded.okhttp3.internal.http.HttpMethod;
import tgbridge.shaded.okhttp3.internal.http.StatusLine;
import tgbridge.shaded.okhttp3.internal.io.FileSystem;
import tgbridge.shaded.okhttp3.internal.platform.Platform;
import tgbridge.shaded.okio.Buffer;
import tgbridge.shaded.okio.BufferedSink;
import tgbridge.shaded.okio.BufferedSource;
import tgbridge.shaded.okio.ByteString;
import tgbridge.shaded.okio.ForwardingSink;
import tgbridge.shaded.okio.ForwardingSource;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.Sink;
import tgbridge.shaded.okio.Source;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010)\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0004ONPQB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u000f2\f\u0010\u000e\u001a\b\u0018\u00010\fR\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u000f\u0010\u0018\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u000f\u00a2\u0006\u0004\b\"\u0010\u0013J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010#J\r\u0010$\u001a\u00020\u001f\u00a2\u0006\u0004\b$\u0010!J\u0019\u0010)\u001a\u0004\u0018\u00010&2\u0006\u0010%\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010,\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b*\u0010+J\r\u0010-\u001a\u00020\u001f\u00a2\u0006\u0004\b-\u0010!J\r\u0010.\u001a\u00020\u0005\u00a2\u0006\u0004\b.\u0010#J\u000f\u00100\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b/\u0010\u0013J\u0017\u00105\u001a\u00020\u000f2\u0006\u00102\u001a\u000201H\u0000\u00a2\u0006\u0004\b3\u00104J\u001f\u0010:\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b8\u00109J\u0013\u0010=\u001a\b\u0012\u0004\u0012\u00020<0;\u00a2\u0006\u0004\b=\u0010>J\r\u0010?\u001a\u00020\u001f\u00a2\u0006\u0004\b?\u0010!J\r\u0010@\u001a\u00020\u001f\u00a2\u0006\u0004\b@\u0010!R\u001a\u0010A\u001a\u00020\r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR\u0011\u0010\u0004\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0016R\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010ER\u0011\u0010G\u001a\u00020F8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0016\u0010$\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010ER\u0016\u0010-\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010ER\"\u0010?\u001a\u00020\u001f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010E\u001a\u0004\bI\u0010!\"\u0004\bJ\u0010KR\"\u0010@\u001a\u00020\u001f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010E\u001a\u0004\bL\u0010!\"\u0004\bM\u0010K\u00a8\u0006R"}, d2={"Ltgbridge/shaded/okhttp3/Cache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "Ljava/io/File;", "directory", "", "maxSize", "<init>", "(Ljava/io/File;J)V", "Ltgbridge/shaded/okhttp3/internal/io/FileSystem;", "fileSystem", "(Ljava/io/File;JLokhttp3/internal/io/FileSystem;)V", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache;", "editor", "", "abortQuietly", "(Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Editor;)V", "close", "()V", "delete", "-deprecated_directory", "()Ljava/io/File;", "evictAll", "flush", "Ltgbridge/shaded/okhttp3/Request;", "request", "Ltgbridge/shaded/okhttp3/Response;", "get$okhttp", "(Ltgbridge/shaded/okhttp3/Request;)Ltgbridge/shaded/okhttp3/Response;", "get", "", "hitCount", "()I", "initialize", "()J", "networkCount", "response", "Ltgbridge/shaded/okhttp3/internal/cache/CacheRequest;", "put$okhttp", "(Ltgbridge/shaded/okhttp3/Response;)Ltgbridge/shaded/okhttp3/internal/cache/CacheRequest;", "put", "remove$okhttp", "(Ltgbridge/shaded/okhttp3/Request;)V", "remove", "requestCount", "size", "trackConditionalCacheHit$okhttp", "trackConditionalCacheHit", "Ltgbridge/shaded/okhttp3/internal/cache/CacheStrategy;", "cacheStrategy", "trackResponse$okhttp", "(Ltgbridge/shaded/okhttp3/internal/cache/CacheStrategy;)V", "trackResponse", "cached", "network", "update$okhttp", "(Ltgbridge/shaded/okhttp3/Response;Ltgbridge/shaded/okhttp3/Response;)V", "update", "", "", "urls", "()Ljava/util/Iterator;", "writeAbortCount", "writeSuccessCount", "cache", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache;", "getCache$okhttp", "()Lokhttp3/internal/cache/DiskLruCache;", "I", "", "isClosed", "()Z", "getWriteAbortCount$okhttp", "setWriteAbortCount$okhttp", "(I)V", "getWriteSuccessCount$okhttp", "setWriteSuccessCount$okhttp", "Companion", "CacheResponseBody", "Entry", "RealCacheRequest", "okhttp"})
public final class Cache
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public Cache(@NotNull File directory, long maxSize, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.cache = new DiskLruCache(fileSystem, directory, 201105, 2, maxSize, TaskRunner.INSTANCE);
    }

    @NotNull
    public final DiskLruCache getCache$okhttp() {
        return this.cache;
    }

    public final int getWriteSuccessCount$okhttp() {
        return this.writeSuccessCount;
    }

    public final void setWriteSuccessCount$okhttp(int n) {
        this.writeSuccessCount = n;
    }

    public final int getWriteAbortCount$okhttp() {
        return this.writeAbortCount;
    }

    public final void setWriteAbortCount$okhttp(int n) {
        this.writeAbortCount = n;
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    public Cache(@NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(directory, maxSize, FileSystem.SYSTEM);
    }

    @Nullable
    public final Response get$okhttp(@NotNull Request request) {
        Entry _2;
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String key = Companion.key(request.url());
        try {
            DiskLruCache.Snapshot snapshot2 = this.cache.get(key);
            if (snapshot2 == null) {
                return null;
            }
            snapshot = snapshot2;
        }
        catch (IOException _2) {
            return null;
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        try {
            _2 = new Entry(snapshot3.getSource(0));
        }
        catch (IOException _3) {
            Util.closeQuietly(snapshot3);
            return null;
        }
        Entry entry = _2;
        Response response = entry.response(snapshot3);
        if (!entry.matches(request, response)) {
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
            return null;
        }
        return response;
    }

    @Nullable
    public final CacheRequest put$okhttp(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String requestMethod = response.request().method();
        if (HttpMethod.INSTANCE.invalidatesCache(response.request().method())) {
            try {
                this.remove$okhttp(response.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!Intrinsics.areEqual((Object)requestMethod, (Object)"GET")) {
            return null;
        }
        if (Companion.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default(this.cache, Companion.key(response.request().url()), 0L, 2, null);
            if (editor2 == null) {
                return null;
            }
            editor = editor2;
            entry.writeTo(editor);
            return new RealCacheRequest(editor);
        }
        catch (IOException _) {
            this.abortQuietly(editor);
            return null;
        }
    }

    public final void remove$okhttp(@NotNull Request request) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.cache.remove(Companion.key(request.url()));
    }

    public final void update$okhttp(@NotNull Response cached, @NotNull Response network) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached.body();
        Intrinsics.checkNotNull((Object)responseBody, (String)"null cannot be cast to non-null type okhttp3.Cache.CacheResponseBody");
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            DiskLruCache.Editor editor2 = snapshot.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            entry.writeTo(editor);
            editor.commit();
        }
        catch (IOException _) {
            this.abortQuietly(editor);
        }
    }

    private final void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2 = editor;
            if (editor2 != null) {
                editor2.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    @NotNull
    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(this){
            @NotNull
            private final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            private String nextUrl;
            private boolean canRemove;
            {
                this.delegate = $receiver.getCache$okhttp().snapshots();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try {
                        Closeable closeable = this.delegate.next();
                        Throwable throwable = null;
                        try {
                            DiskLruCache.Snapshot snapshot = (DiskLruCache.Snapshot)closeable;
                            boolean bl = false;
                            BufferedSource metadata = Okio.buffer(snapshot.getSource(0));
                            this.nextUrl = metadata.readUtf8LineStrict();
                            boolean bl2 = true;
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return false;
            }

            @NotNull
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                Intrinsics.checkNotNull((Object)string);
                String result = string;
                this.nextUrl = null;
                this.canRemove = true;
                return result;
            }

            public void remove() {
                if (!this.canRemove) {
                    boolean bl = false;
                    String string = "remove() before next()";
                    throw new IllegalStateException(string.toString());
                }
                this.delegate.remove();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    @JvmName(name="directory")
    @NotNull
    public final File directory() {
        return this.cache.getDirectory();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="directory", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_directory")
    @NotNull
    public final File -deprecated_directory() {
        return this.cache.getDirectory();
    }

    public final synchronized void trackResponse$okhttp(@NotNull CacheStrategy cacheStrategy) {
        Intrinsics.checkNotNullParameter((Object)cacheStrategy, (String)"cacheStrategy");
        int n = this.requestCount;
        this.requestCount = n + 1;
        if (cacheStrategy.getNetworkRequest() != null) {
            n = this.networkCount;
            this.networkCount = n + 1;
        } else if (cacheStrategy.getCacheResponse() != null) {
            n = this.hitCount;
            this.hitCount = n + 1;
        }
    }

    public final synchronized void trackConditionalCacheHit$okhttp() {
        int n = this.hitCount;
        this.hitCount = n + 1;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    @JvmStatic
    @NotNull
    public static final String key(@NotNull HttpUrl url) {
        return Companion.key(url);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0007\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0011\u0010\u0006\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u0006\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0013R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0013R\u001b\u0010\u0004\u001a\u00060\u0002R\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ltgbridge/shaded/okhttp3/Cache$CacheResponseBody;", "Ltgbridge/shaded/okhttp3/ResponseBody;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache;", "snapshot", "", "contentType", "contentLength", "<init>", "(Lokhttp3/internal/cache/DiskLruCache$Snapshot;Ljava/lang/String;Ljava/lang/String;)V", "", "()J", "Ltgbridge/shaded/okhttp3/MediaType;", "()Ltgbridge/shaded/okhttp3/MediaType;", "Ltgbridge/shaded/okio/BufferedSource;", "source", "()Ltgbridge/shaded/okio/BufferedSource;", "bodySource", "Ltgbridge/shaded/okio/BufferedSource;", "Ljava/lang/String;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "getSnapshot", "()Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "okhttp"})
    private static final class CacheResponseBody
    extends ResponseBody {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;
        @NotNull
        private final BufferedSource bodySource;

        public CacheResponseBody(@NotNull DiskLruCache.Snapshot snapshot, @Nullable String contentType, @Nullable String contentLength) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.snapshot = snapshot;
            this.contentType = contentType;
            this.contentLength = contentLength;
            Source source2 = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource(source2){

                @Override
                public void close() throws IOException {
                    this.getSnapshot().close();
                    super.close();
                }
            });
        }

        @NotNull
        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @Nullable
        public MediaType contentType() {
            String string = this.contentType;
            return string != null ? MediaType.Companion.parse(string) : null;
        }

        @Override
        public long contentLength() {
            String string = this.contentLength;
            return string != null ? Util.toLongOrDefault(string, -1L) : -1L;
        }

        @Override
        @NotNull
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u0019*\u00020\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e*\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0011\u0010\u0012\u001a\u00020\u000f*\u00020\u0014\u00a2\u0006\u0004\b\u0012\u0010!R\u0014\u0010\"\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0014\u0010%\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010#\u00a8\u0006'"}, d2={"Ltgbridge/shaded/okhttp3/Cache$Companion;", "", "<init>", "()V", "Ltgbridge/shaded/okhttp3/HttpUrl;", "url", "", "key", "(Ltgbridge/shaded/okhttp3/HttpUrl;)Ljava/lang/String;", "Ltgbridge/shaded/okio/BufferedSource;", "source", "", "readInt$okhttp", "(Ltgbridge/shaded/okio/BufferedSource;)I", "readInt", "Ltgbridge/shaded/okhttp3/Headers;", "requestHeaders", "responseHeaders", "varyHeaders", "(Ltgbridge/shaded/okhttp3/Headers;Ltgbridge/shaded/okhttp3/Headers;)Ltgbridge/shaded/okhttp3/Headers;", "Ltgbridge/shaded/okhttp3/Response;", "cachedResponse", "cachedRequest", "Ltgbridge/shaded/okhttp3/Request;", "newRequest", "", "varyMatches", "(Ltgbridge/shaded/okhttp3/Response;Ltgbridge/shaded/okhttp3/Headers;Ltgbridge/shaded/okhttp3/Request;)Z", "hasVaryAll", "(Ltgbridge/shaded/okhttp3/Response;)Z", "", "varyFields", "(Ltgbridge/shaded/okhttp3/Headers;)Ljava/util/Set;", "(Ltgbridge/shaded/okhttp3/Response;)Ltgbridge/shaded/okhttp3/Headers;", "ENTRY_BODY", "I", "ENTRY_COUNT", "ENTRY_METADATA", "VERSION", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,788:1\n2624#2,3:789\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n*L\n729#1:789,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String key(@NotNull HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return ByteString.Companion.encodeUtf8(url.toString()).md5().hex();
        }

        public final int readInt$okhttp(@NotNull BufferedSource source2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            try {
                long result = source2.readDecimalLong();
                String line = source2.readUtf8LineStrict();
                if (result < 0L || result > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    throw new IOException("expected an int but was \"" + result + line + '\"');
                }
                return (int)result;
            }
            catch (NumberFormatException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean varyMatches(@NotNull Response cachedResponse, @NotNull Headers cachedRequest, @NotNull Request newRequest) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
                Intrinsics.checkNotNullParameter((Object)cachedRequest, (String)"cachedRequest");
                Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
                Iterable $this$none$iv = this.varyFields(cachedResponse.headers());
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual(cachedRequest.values(it), newRequest.headers(it)))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean hasVaryAll(@NotNull Response $this$hasVaryAll) {
            Intrinsics.checkNotNullParameter((Object)$this$hasVaryAll, (String)"<this>");
            return this.varyFields($this$hasVaryAll.headers()).contains("*");
        }

        private final Set<String> varyFields(Headers $this$varyFields) {
            Set result = null;
            int n = $this$varyFields.size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)"Vary", (String)$this$varyFields.name(i), (boolean)true)) continue;
                String value = $this$varyFields.value(i);
                if (result == null) {
                    result = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[]{','};
                for (String varyField : StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                    result.add(((Object)StringsKt.trim((CharSequence)varyField)).toString());
                }
            }
            Set set = result;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public final Headers varyHeaders(@NotNull Response $this$varyHeaders) {
            Intrinsics.checkNotNullParameter((Object)$this$varyHeaders, (String)"<this>");
            Response response = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull((Object)response);
            Headers requestHeaders = response.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            return this.varyHeaders(requestHeaders, responseHeaders);
        }

        private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
            Set<String> varyFields = this.varyFields(responseHeaders);
            if (varyFields.isEmpty()) {
                return Util.EMPTY_HEADERS;
            }
            Headers.Builder result = new Headers.Builder();
            int n = requestHeaders.size();
            for (int i = 0; i < n; ++i) {
                String fieldName = requestHeaders.name(i);
                if (!varyFields.contains(fieldName)) continue;
                result.add(fieldName, requestHeaders.value(i));
            }
            return result.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0007\u001a\u00020\u00062\n\u0010\u0016\u001a\u00060\u0014R\u00020\u0015\u00a2\u0006\u0004\b\u0007\u0010\u0017J%\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010 \u001a\u00020\u001b2\n\u0010\u001f\u001a\u00060\u001eR\u00020\u0015\u00a2\u0006\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u0004\u0018\u00010%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u0010,R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00107\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00102R\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010;\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00106\u00a8\u0006="}, d2={"Ltgbridge/shaded/okhttp3/Cache$Entry;", "", "Ltgbridge/shaded/okio/Source;", "rawSource", "<init>", "(Lokio/Source;)V", "Ltgbridge/shaded/okhttp3/Response;", "response", "(Lokhttp3/Response;)V", "Ltgbridge/shaded/okhttp3/Request;", "request", "", "matches", "(Ltgbridge/shaded/okhttp3/Request;Ltgbridge/shaded/okhttp3/Response;)Z", "Ltgbridge/shaded/okio/BufferedSource;", "source", "", "Ljava/security/cert/Certificate;", "readCertificateList", "(Ltgbridge/shaded/okio/BufferedSource;)Ljava/util/List;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache;", "snapshot", "(Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Snapshot;)Ltgbridge/shaded/okhttp3/Response;", "Ltgbridge/shaded/okio/BufferedSink;", "sink", "certificates", "", "writeCertList", "(Ltgbridge/shaded/okio/BufferedSink;Ljava/util/List;)V", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "editor", "writeTo", "(Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Editor;)V", "", "code", "I", "Ltgbridge/shaded/okhttp3/Handshake;", "handshake", "Ltgbridge/shaded/okhttp3/Handshake;", "isHttps", "()Z", "", "message", "Ljava/lang/String;", "Ltgbridge/shaded/okhttp3/Protocol;", "protocol", "Ltgbridge/shaded/okhttp3/Protocol;", "", "receivedResponseMillis", "J", "requestMethod", "Ltgbridge/shaded/okhttp3/Headers;", "responseHeaders", "Ltgbridge/shaded/okhttp3/Headers;", "sentRequestMillis", "Ltgbridge/shaded/okhttp3/HttpUrl;", "url", "Ltgbridge/shaded/okhttp3/HttpUrl;", "varyHeaders", "Companion", "okhttp"})
    private static final class Entry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HttpUrl url;
        @NotNull
        private final Headers varyHeaders;
        @NotNull
        private final String requestMethod;
        @NotNull
        private final Protocol protocol;
        private final int code;
        @NotNull
        private final String message;
        @NotNull
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        @NotNull
        private static final String SENT_MILLIS = Platform.Companion.get().getPrefix() + "-Sent-Millis";
        @NotNull
        private static final String RECEIVED_MILLIS = Platform.Companion.get().getPrefix() + "-Received-Millis";

        private final boolean isHttps() {
            return Intrinsics.areEqual((Object)this.url.scheme(), (Object)"https");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public Entry(@NotNull Source rawSource) throws IOException {
            Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
            Closeable closeable = rawSource;
            Throwable throwable = null;
            try {
                Source it = (Source)closeable;
                boolean bl = false;
                BufferedSource source2 = Okio.buffer(rawSource);
                String urlLine = source2.readUtf8LineStrict();
                HttpUrl httpUrl = HttpUrl.Companion.parse(urlLine);
                if (httpUrl == null) {
                    void it2;
                    IOException iOException;
                    IOException iOException2 = iOException = new IOException("Cache corruption for " + urlLine);
                    Entry entry = this;
                    boolean bl2 = false;
                    Platform.Companion.get().log("cache corruption", 5, (Throwable)it2);
                    Entry entry2 = entry;
                    throw (Throwable)iOException;
                }
                this.url = httpUrl;
                this.requestMethod = source2.readUtf8LineStrict();
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Companion.readInt$okhttp(source2);
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    varyHeadersBuilder.addLenient$okhttp(source2.readUtf8LineStrict());
                }
                this.varyHeaders = varyHeadersBuilder.build();
                StatusLine statusLine = StatusLine.Companion.parse(source2.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Companion.readInt$okhttp(source2);
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    responseHeadersBuilder.addLenient$okhttp(source2.readUtf8LineStrict());
                }
                String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                responseHeadersBuilder.removeAll(SENT_MILLIS);
                responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                String string = sendRequestMillisString;
                this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                String string2 = receivedResponseMillisString;
                this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.isHttps()) {
                    String blank = source2.readUtf8LineStrict();
                    if (((CharSequence)blank).length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + '\"');
                    }
                    String cipherSuiteString = source2.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                    List<Certificate> peerCertificates2 = this.readCertificateList(source2);
                    List<Certificate> localCertificates = this.readCertificateList(source2);
                    TlsVersion tlsVersion = !source2.exhausted() ? TlsVersion.Companion.forJavaName(source2.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.Companion.get(tlsVersion, cipherSuite, peerCertificates2, localCertificates);
                } else {
                    this.handshake = null;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public Entry(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.url = response.request().url();
            this.varyHeaders = Companion.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeTo(@NotNull DiskLruCache.Editor editor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Closeable closeable = Okio.buffer(editor.newSink(0));
            Throwable throwable = null;
            try {
                int i;
                BufferedSink sink2 = (BufferedSink)closeable;
                boolean bl = false;
                sink2.writeUtf8(this.url.toString()).writeByte(10);
                sink2.writeUtf8(this.requestMethod).writeByte(10);
                sink2.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
                int n = this.varyHeaders.size();
                for (i = 0; i < n; ++i) {
                    sink2.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
                }
                sink2.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                sink2.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
                n = this.responseHeaders.size();
                for (i = 0; i < n; ++i) {
                    sink2.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
                }
                sink2.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                sink2.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                if (this.isHttps()) {
                    sink2.writeByte(10);
                    Handshake handshake2 = this.handshake;
                    Intrinsics.checkNotNull((Object)handshake2);
                    sink2.writeUtf8(handshake2.cipherSuite().javaName()).writeByte(10);
                    this.writeCertList(sink2, this.handshake.peerCertificates());
                    this.writeCertList(sink2, this.handshake.localCertificates());
                    sink2.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final List<Certificate> readCertificateList(BufferedSource source2) throws IOException {
            int length = Companion.readInt$okhttp(source2);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    ByteString certificateBytes;
                    String line = source2.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    if (ByteString.Companion.decodeBase64(line) == null) {
                        throw new IOException("Corrupt certificate in cache entry");
                    }
                    bytes.write(certificateBytes);
                    result.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private final void writeCertList(BufferedSink sink2, List<? extends Certificate> certificates) throws IOException {
            try {
                sink2.writeDecimalLong(certificates.size()).writeByte(10);
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                    String line = ByteString.Companion.of$default(ByteString.Companion, bytes, 0, 0, 3, null).base64();
                    sink2.writeUtf8(line).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public final boolean matches(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return Intrinsics.areEqual((Object)this.url, (Object)request.url()) && Intrinsics.areEqual((Object)this.requestMethod, (Object)request.method()) && Companion.varyMatches(response, this.varyHeaders, request);
        }

        @NotNull
        public final Response response(@NotNull DiskLruCache.Snapshot snapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, contentType, contentLength)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Ltgbridge/shaded/okhttp3/Cache$Entry$Companion;", "", "<init>", "()V", "", "RECEIVED_MILLIS", "Ljava/lang/String;", "SENT_MILLIS", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0004\u001a\u00060\u0002R\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ltgbridge/shaded/okhttp3/Cache$RealCacheRequest;", "Ltgbridge/shaded/okhttp3/internal/cache/CacheRequest;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache;", "editor", "<init>", "(Lokhttp3/Cache;Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "", "abort", "()V", "Ltgbridge/shaded/okio/Sink;", "body", "()Ltgbridge/shaded/okio/Sink;", "Ltgbridge/shaded/okio/Sink;", "cacheOut", "", "done", "Z", "getDone", "()Z", "setDone", "(Z)V", "Ltgbridge/shaded/okhttp3/internal/cache/DiskLruCache$Editor;", "okhttp"})
    private final class RealCacheRequest
    implements CacheRequest {
        @NotNull
        private final DiskLruCache.Editor editor;
        @NotNull
        private final Sink cacheOut;
        @NotNull
        private final Sink body;
        private boolean done;

        public RealCacheRequest(DiskLruCache.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.cacheOut = this.editor.newSink(1);
            Sink sink2 = this.cacheOut;
            this.body = new ForwardingSink(sink2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    RealCacheRequest realCacheRequest = this;
                    Cache cache2 = Cache.this;
                    Cache cache3 = cache;
                    synchronized (cache3) {
                        boolean bl = false;
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = cache2.getWriteSuccessCount$okhttp();
                        cache2.setWriteSuccessCount$okhttp(n + 1);
                        int n2 = n;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            Cache cache2 = Cache.this;
            Cache cache3 = cache;
            synchronized (cache3) {
                boolean bl = false;
                if (this.done) {
                    return;
                }
                this.done = true;
                int n = cache2.getWriteAbortCount$okhttp();
                cache2.setWriteAbortCount$okhttp(n + 1);
                int n2 = n;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        @NotNull
        public Sink body() {
            return this.body;
        }
    }
}

